/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.directory;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import nl.topicus.cobra.restcontract.annotation.ExcludeFromMapping;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.keyhub.servicecontract.annotations.CertificateOnly;
import nl.topicus.keyhub.servicecontract.annotations.Sensitive;
import nl.topicus.keyhub.servicecontract.model.CertificateHolder;
import nl.topicus.keyhub.servicecontract.model.TLSLevel;
import nl.topicus.keyhub.servicecontract.model.certificate.CertificatePrimer;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectory;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryType;
import nl.topicus.keyhub.servicecontract.model.directory.DirectoryRotatingPassword;
import nl.topicus.keyhub.servicecontract.model.directory.LDAPDialect;
import nl.topicus.keyhub.servicecontract.model.directory.LDAPDirectoryPasswordRecovery;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnitPrimer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@WriteScope(value={LDAPDirectory.class})
public class LDAPDirectory
extends AccountDirectory
implements CertificateHolder {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @NotNull
    private LDAPDialect dialect = LDAPDialect.ACTIVE_DIRECTORY;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String host;
    @XmlElement
    private int port;
    @XmlElement
    private String failoverHost;
    @XmlElement
    @NotNull
    private TLSLevel tls;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String baseDN;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String searchBindDN;
    @Sensitive
    @XmlElement
    @Size(max=128)
    private @Size(max=128) String searchBindPassword;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String searchFilter;
    @XmlElement
    @NotNull
    private LDAPDirectoryPasswordRecovery passwordRecovery;
    @XmlElement
    @CertificateOnly
    @ExcludeFromMapping
    private CertificatePrimer trustedCertificate;
    @XmlElement
    @CertificateOnly
    @ExcludeFromMapping
    private CertificatePrimer failoverTrustedCertificate;
    @XmlElement
    @ExcludeFromMapping
    private CertificatePrimer clientCertificate;
    @XmlElement
    @Size(max=512)
    private @Size(max=512) String attributesToStore;

    public static LDAPDirectory createDefault(OrganizationalUnitPrimer baseOrganizationalUnit) {
        LDAPDirectory newDirectory = new LDAPDirectory();
        newDirectory.setType(AccountDirectoryType.LDAP);
        newDirectory.setTls(TLSLevel.SECURE);
        newDirectory.setActive(true);
        newDirectory.setPort(389);
        newDirectory.setRotatingPassword(DirectoryRotatingPassword.DEFAULT_OFF);
        newDirectory.setPasswordRecovery(LDAPDirectoryPasswordRecovery.DISABLED);
        newDirectory.setBaseOrganizationalUnit(baseOrganizationalUnit);
        return newDirectory;
    }

    public LDAPDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(LDAPDialect dialect) {
        this.dialect = dialect;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFailoverHost() {
        return this.failoverHost;
    }

    public void setFailoverHost(String failoverHost) {
        this.failoverHost = failoverHost;
    }

    @Override
    public TLSLevel getTls() {
        return this.tls;
    }

    @Override
    public void setTls(TLSLevel tls) {
        this.tls = tls;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getSearchBindDN() {
        return this.searchBindDN;
    }

    public void setSearchBindDN(String searchBindDN) {
        this.searchBindDN = searchBindDN;
    }

    public String getSearchBindPassword() {
        return this.searchBindPassword;
    }

    public void setSearchBindPassword(String searchBindPassword) {
        this.searchBindPassword = searchBindPassword;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public LDAPDirectoryPasswordRecovery getPasswordRecovery() {
        return this.passwordRecovery;
    }

    public void setPasswordRecovery(LDAPDirectoryPasswordRecovery passwordRecovery) {
        this.passwordRecovery = passwordRecovery;
    }

    @Override
    public CertificatePrimer getTrustedCertificate() {
        return this.trustedCertificate;
    }

    @Override
    public void setTrustedCertificate(CertificatePrimer trustedCertificate) {
        this.trustedCertificate = trustedCertificate;
    }

    @Override
    public CertificatePrimer getFailoverTrustedCertificate() {
        return this.failoverTrustedCertificate;
    }

    @Override
    public void setFailoverTrustedCertificate(CertificatePrimer failoverTrustedCertificate) {
        this.failoverTrustedCertificate = failoverTrustedCertificate;
    }

    @Override
    public CertificatePrimer getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public void setClientCertificate(CertificatePrimer clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public String getAttributesToStore() {
        return this.attributesToStore;
    }

    public void setAttributesToStore(String attributesToStore) {
        this.attributesToStore = attributesToStore;
    }
}

