/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.directory;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectory;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryStatusReport;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryType;
import nl.topicus.keyhub.servicecontract.model.directory.OIDCDirectory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class AccountDirectorySummary
extends Linkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String name;
    @XmlElement
    private boolean usernameCustomizable;
    @XmlElement
    private AccountDirectoryStatusReport status;
    @XmlElement
    private AccountDirectoryType type;
    @XmlElement
    private String fullyResolvedIssuer;
    @XmlElement
    private String domainRestriction;

    public AccountDirectorySummary() {
    }

    public AccountDirectorySummary(AccountDirectory directory, AccountDirectoryStatusReport status) {
        this.setLink(directory.self());
        this.setName(directory.getName());
        this.setUsernameCustomizable(directory.isUsernameCustomizable());
        this.setType(directory.getType());
        this.setStatus(status);
        if (directory.getType() == AccountDirectoryType.OIDC) {
            OIDCDirectory oidcDirectory = (OIDCDirectory)directory;
            this.setFullyResolvedIssuer(oidcDirectory.getFullyResolvedIssuer());
            this.setDomainRestriction(oidcDirectory.getMainDomainRestriction());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUsernameCustomizable() {
        return this.usernameCustomizable;
    }

    public void setUsernameCustomizable(boolean usernameCustomizable) {
        this.usernameCustomizable = usernameCustomizable;
    }

    public AccountDirectoryStatusReport getStatus() {
        return this.status;
    }

    public void setStatus(AccountDirectoryStatusReport status) {
        this.status = status;
    }

    public AccountDirectoryType getType() {
        return this.type;
    }

    public void setType(AccountDirectoryType type) {
        this.type = type;
    }

    public String getFullyResolvedIssuer() {
        return this.fullyResolvedIssuer;
    }

    public void setFullyResolvedIssuer(String fullyResolvedIssuer) {
        this.fullyResolvedIssuer = fullyResolvedIssuer;
    }

    public String getDomainRestriction() {
        return this.domainRestriction;
    }

    public void setDomainRestriction(String domainRestriction) {
        this.domainRestriction = domainRestriction;
    }

    @Override
    public String toOmschrijving() {
        return this.getName();
    }
}

