/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.config;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Duration;
import java.time.Period;
import nl.topicus.cobra.restcontract.model.NonLinkable;
import nl.topicus.keyhub.servicecontract.annotations.CertificateOnly;
import nl.topicus.keyhub.servicecontract.model.auth.AccountLicenseRole;
import nl.topicus.keyhub.servicecontract.model.certificate.Certificate;
import nl.topicus.keyhub.servicecontract.model.config.VaultRecoveryKey;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;
import nl.topicus.keyhub.servicecontract.model.license.KeyHubLicenseInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Settings
extends NonLinkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private int passwordMinLength;
    @XmlElement
    @NotNull
    private Duration webSessionTimeout;
    @XmlElement
    @NotNull
    private Duration passwordAuthTimeout;
    @XmlElement
    @NotNull
    private Duration twoFactorAuthTimeout;
    @XmlElement
    private VaultRecoveryKey vaultRecoveryKey;
    @XmlElement
    private String domain;
    @XmlElement
    private Certificate ldapServerCertificate;
    @XmlElement
    private String responsibleDisclosure;
    @XmlElement
    private KeyHubLicenseInfo licenseInfo;
    @XmlElement
    private boolean provisioningTracing;
    @XmlElement
    private boolean performanceLogging;
    @XmlElement
    private String brandingLogo;
    @XmlElement
    private String maintenanceMessage;
    @XmlElement
    @NotBlank
    private String passwordGenerator;
    @XmlElement
    @CertificateOnly
    private Certificate idpCertificate;
    @XmlElement
    private String createGroupPlaceholder;
    @XmlElement
    @NotNull
    private GroupPrimer createGroupApproval;
    @XmlElement
    @NotNull
    private GroupPrimer removeGroupApproval;
    @XmlElement
    @NotNull
    private GroupPrimer enableTechAdminApproval;
    @XmlElement
    @NotNull
    private GroupPrimer recoveryFallback;
    @XmlElement
    @NotNull
    private GroupPrimer auditorGroup;
    @XmlElement
    private Period auditRecordRetention;
    @XmlElement
    private Period auditRecordPseudonymization;
    @XmlElement
    @NotNull
    private AccountLicenseRole defaultLicenseRole;

    public Settings() {
    }

    public Settings(Settings copy) {
        this.passwordMinLength = copy.getPasswordMinLength();
        this.webSessionTimeout = copy.getWebSessionTimeout();
        this.passwordAuthTimeout = copy.getPasswordAuthTimeout();
        this.twoFactorAuthTimeout = copy.getTwoFactorAuthTimeout();
        this.vaultRecoveryKey = copy.getVaultRecoveryKey() != null ? new VaultRecoveryKey(copy.getVaultRecoveryKey()) : null;
        this.domain = copy.getDomain();
        this.ldapServerCertificate = copy.getLdapServerCertificate();
        this.responsibleDisclosure = copy.getResponsibleDisclosure();
        this.licenseInfo = copy.getLicenseInfo() != null ? new KeyHubLicenseInfo(copy.getLicenseInfo()) : null;
        this.provisioningTracing = copy.isProvisioningTracing();
        this.performanceLogging = copy.isPerformanceLogging();
        this.brandingLogo = copy.getBrandingLogo();
        this.maintenanceMessage = copy.getMaintenanceMessage();
        this.passwordGenerator = copy.getPasswordGenerator();
        this.idpCertificate = copy.getIdpCertificate();
        this.createGroupPlaceholder = copy.getCreateGroupPlaceholder();
        this.createGroupApproval = copy.getCreateGroupApproval();
        this.removeGroupApproval = copy.getRemoveGroupApproval();
        this.enableTechAdminApproval = copy.getEnableTechAdminApproval();
        this.recoveryFallback = copy.getRecoveryFallback();
        this.auditorGroup = copy.getAuditorGroup();
        this.auditRecordRetention = copy.getAuditRecordRetention();
        this.auditRecordPseudonymization = copy.getAuditRecordPseudonymization();
        this.defaultLicenseRole = copy.getDefaultLicenseRole();
    }

    public int getPasswordMinLength() {
        return this.passwordMinLength;
    }

    public void setPasswordMinLength(int passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public Duration getWebSessionTimeout() {
        return this.webSessionTimeout;
    }

    public void setWebSessionTimeout(Duration webSessionTimeout) {
        this.webSessionTimeout = webSessionTimeout;
    }

    public Duration getPasswordAuthTimeout() {
        return this.passwordAuthTimeout;
    }

    public void setPasswordAuthTimeout(Duration passwordAuthTimeout) {
        this.passwordAuthTimeout = passwordAuthTimeout;
    }

    public Duration getTwoFactorAuthTimeout() {
        return this.twoFactorAuthTimeout;
    }

    public void setTwoFactorAuthTimeout(Duration twoFactorAuthTimeout) {
        this.twoFactorAuthTimeout = twoFactorAuthTimeout;
    }

    public VaultRecoveryKey getVaultRecoveryKey() {
        return this.vaultRecoveryKey;
    }

    public void setVaultRecoveryKey(VaultRecoveryKey vaultRecoveryKey) {
        this.vaultRecoveryKey = vaultRecoveryKey;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Certificate getLdapServerCertificate() {
        return this.ldapServerCertificate;
    }

    public void setLdapServerCertificate(Certificate ldapServerCertificate) {
        this.ldapServerCertificate = ldapServerCertificate;
    }

    public String getResponsibleDisclosure() {
        return this.responsibleDisclosure;
    }

    public void setResponsibleDisclosure(String responsibleDisclosure) {
        this.responsibleDisclosure = responsibleDisclosure;
    }

    public KeyHubLicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public void setLicenseInfo(KeyHubLicenseInfo licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    public boolean isProvisioningTracing() {
        return this.provisioningTracing;
    }

    public void setProvisioningTracing(boolean provisioningTracing) {
        this.provisioningTracing = provisioningTracing;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public String getBrandingLogo() {
        return this.brandingLogo;
    }

    public void setBrandingLogo(String brandingLogo) {
        this.brandingLogo = brandingLogo;
    }

    public String getMaintenanceMessage() {
        return this.maintenanceMessage;
    }

    public void setMaintenanceMessage(String maintenanceMessage) {
        this.maintenanceMessage = maintenanceMessage;
    }

    public String getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setPasswordGenerator(String passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    public Certificate getIdpCertificate() {
        return this.idpCertificate;
    }

    public void setIdpCertificate(Certificate idpCertificate) {
        this.idpCertificate = idpCertificate;
    }

    public String getCreateGroupPlaceholder() {
        return this.createGroupPlaceholder;
    }

    public void setCreateGroupPlaceholder(String createGroupPlaceholder) {
        this.createGroupPlaceholder = createGroupPlaceholder;
    }

    public GroupPrimer getCreateGroupApproval() {
        return this.createGroupApproval;
    }

    public void setCreateGroupApproval(GroupPrimer createGroupApproval) {
        this.createGroupApproval = createGroupApproval;
    }

    public GroupPrimer getRemoveGroupApproval() {
        return this.removeGroupApproval;
    }

    public void setRemoveGroupApproval(GroupPrimer removeGroupApproval) {
        this.removeGroupApproval = removeGroupApproval;
    }

    public GroupPrimer getEnableTechAdminApproval() {
        return this.enableTechAdminApproval;
    }

    public void setEnableTechAdminApproval(GroupPrimer enableTechAdminApproval) {
        this.enableTechAdminApproval = enableTechAdminApproval;
    }

    public GroupPrimer getRecoveryFallback() {
        return this.recoveryFallback;
    }

    public void setRecoveryFallback(GroupPrimer recoveryFallback) {
        this.recoveryFallback = recoveryFallback;
    }

    public GroupPrimer getAuditorGroup() {
        return this.auditorGroup;
    }

    public void setAuditorGroup(GroupPrimer auditorGroup) {
        this.auditorGroup = auditorGroup;
    }

    public Period getAuditRecordRetention() {
        return this.auditRecordRetention;
    }

    public void setAuditRecordRetention(Period auditRecordRetention) {
        this.auditRecordRetention = auditRecordRetention;
    }

    public Period getAuditRecordPseudonymization() {
        return this.auditRecordPseudonymization;
    }

    public void setAuditRecordPseudonymization(Period auditRecordPseudonymization) {
        this.auditRecordPseudonymization = auditRecordPseudonymization;
    }

    public AccountLicenseRole getDefaultLicenseRole() {
        return this.defaultLicenseRole;
    }

    public void setDefaultLicenseRole(AccountLicenseRole defaultLicenseRole) {
        this.defaultLicenseRole = defaultLicenseRole;
    }
}

