/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.client;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.cobra.restcontract.annotation.ExcludeFromMapping;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.cobra.restcontract.model.auth.Permission;
import nl.topicus.cobra.restcontract.xmladapter.StringMapAdapter;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplication;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2ClientProfile;
import nl.topicus.keyhub.servicecontract.model.vault.VaultHolder;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordPrimer;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@WriteScope(value={OAuth2Client.class})
public class OAuth2Client
extends ClientApplication
implements VaultHolder {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String callbackURI;
    @XmlElement
    private String initiateLoginURI;
    @XmlElement
    private boolean showLandingPage = false;
    @XmlElement
    private boolean debugMode;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean useClientCredentials = false;
    @XmlElement
    @NotNull
    private OAuth2ClientProfile profile = OAuth2ClientProfile.WEB_APPLICATION;
    @XmlElementWrapper(name="permissions")
    @XmlElement(name="permission")
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private List<Permission> accountPermissions = new ArrayList<Permission>();
    @XmlElement
    @XmlJavaTypeAdapter(value=StringMapAdapter.class)
    @ExcludeFromMapping
    private Map<String, String> attributes = new HashMap<String, String>();
    @XmlElement
    @Size(max=512)
    private @Size(max=512) String idTokenClaims;
    @XmlElement
    private String resourceURIs;
    @XmlElement
    private boolean shareSecretInVault = true;
    @XmlElement
    @ExcludeFromMapping
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private VaultRecordPrimer sharedSecret;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean forIdentitySource = false;

    public OAuth2Client() {
    }

    public OAuth2Client(ClientApplication client) {
        super(client);
    }

    public String getCallbackURI() {
        return this.callbackURI;
    }

    public void setCallbackURI(String callbackURI) {
        this.callbackURI = callbackURI;
    }

    public String getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(String initiateLoginURI) {
        this.initiateLoginURI = initiateLoginURI;
    }

    public boolean isShowLandingPage() {
        return this.showLandingPage;
    }

    public void setShowLandingPage(boolean showLandingPage) {
        this.showLandingPage = showLandingPage;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isUseClientCredentials() {
        return this.useClientCredentials;
    }

    public void setUseClientCredentials(boolean useClientCredentials) {
        this.useClientCredentials = useClientCredentials;
    }

    public OAuth2ClientProfile getProfile() {
        return this.profile;
    }

    public void setProfile(OAuth2ClientProfile profile) {
        this.profile = profile;
    }

    public List<Permission> getAccountPermissions() {
        return this.accountPermissions;
    }

    public void setAccountPermissions(List<Permission> accountPermissions) {
        this.accountPermissions = accountPermissions;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getIdTokenClaims() {
        return this.idTokenClaims;
    }

    public void setIdTokenClaims(String idTokenClaims) {
        this.idTokenClaims = idTokenClaims;
    }

    public String getResourceURIs() {
        return this.resourceURIs;
    }

    public void setResourceURIs(String resourceURIs) {
        this.resourceURIs = resourceURIs;
    }

    public boolean isShareSecretInVault() {
        return this.shareSecretInVault;
    }

    public void setShareSecretInVault(boolean shareSecretInVault) {
        this.shareSecretInVault = shareSecretInVault;
    }

    public VaultRecordPrimer getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(VaultRecordPrimer sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public boolean isForIdentitySource() {
        return this.forIdentitySource;
    }

    public void setForIdentitySource(boolean forIdentitySource) {
        this.forIdentitySource = forIdentitySource;
    }

    @Override
    public boolean isSsoApplication() {
        return !this.getProfile().equals((Object)OAuth2ClientProfile.SERVER_TO_SERVER);
    }
}

