/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.client;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.PrimerFor;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.annotations.BackendDeterminesDefault;
import nl.topicus.keyhub.servicecontract.annotations.Immutable;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplication;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplicationType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@OnResource(value="/client")
@PrimerFor(value=ClientApplication.class)
public class ClientApplicationPrimer
extends Linkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @Size(max=36)
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Immutable
    private @Size(max=36) String uuid;
    @XmlElement
    @Size(max=255)
    @BackendDeterminesDefault
    private @Size(max=255) String clientId;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Immutable
    private ClientApplicationType type;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @XmlElementWrapper(name="scopes")
    @XmlElement(name="scope")
    @BackendDeterminesDefault
    private List<String> scopes;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Immutable
    private boolean ssoApplication = true;

    public ClientApplicationPrimer() {
    }

    public ClientApplicationPrimer(ClientApplicationPrimer client) {
        if (client.self() != null) {
            this.setLink(client.self());
        }
        this.setUuid(client.getUuid());
        this.setClientId(client.getClientId());
        this.setType(client.getType());
        this.setName(client.getName());
        this.setScopes(client.getScopes());
        this.setSsoApplication(client.isSsoApplication());
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ClientApplicationType getType() {
        return this.type;
    }

    public void setType(ClientApplicationType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean isSsoApplication() {
        return this.ssoApplication;
    }

    public void setSsoApplication(boolean ssoApplication) {
        this.ssoApplication = ssoApplication;
    }

    @Override
    public String toOmschrijving() {
        return this.getName();
    }
}

