/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.auth;

import java.util.Map;

public enum AccountAttribute {
    ACCOUNT_ID,
    DIRECTORY_TYPE,
    DIRECTORY_ID,
    STATE,
    SECURITY_LEVEL,
    AUTH_REQ_FOR_VAULT,
    PARTY_SECRET,
    WEB_AUTHN_PRF_KEY,
    WEB_AUTHN_KEY_ID,
    WEB_AUTHN_PRF_KEY_LINKED,
    CUSTOM_ATTRIBUTES,
    DOMAIN_RESTRICTION,
    LOGIN_HINT,
    SHOW_LANDING_PAGE,
    CLIENT_NAME,
    PASSWORD_RESET_TYPE;


    public static boolean hasVaultUnlockKey(Map<String, String> attrs) {
        if (attrs.containsKey(PARTY_SECRET.name())) {
            return true;
        }
        if (attrs.containsKey(WEB_AUTHN_PRF_KEY.name())) {
            return Boolean.parseBoolean(attrs.get(WEB_AUTHN_PRF_KEY_LINKED.name()));
        }
        return false;
    }

    public static enum AccountState {
        EXISTS,
        NEW,
        REREGISTRATION_REQUIRED,
        RESET_PENDING,
        OFFSET_CHANGE_NEEDED,
        INVALID;

    }
}

