/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.audit;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Instant;
import java.time.LocalDate;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.PartOf;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.model.audit.AuditAccountAction;
import nl.topicus.keyhub.servicecontract.model.audit.GroupAudit;
import nl.topicus.keyhub.servicecontract.model.group.GroupRights;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@OnResource(value="account", under=GroupAudit.class)
@PartOf(value={GroupAudit.class})
public class GroupAuditAccount
extends Linkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String accountUuid;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String username;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String displayName;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private LocalDate lastUsed;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private Instant lastActive;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private GroupRights rights;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private LocalDate endDate;
    @XmlElement
    private AuditAccountAction action;
    @XmlElement
    private String comment;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean accountValid;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean nested;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean disconnectedNested;

    public String getAccountUuid() {
        return this.accountUuid;
    }

    public void setAccountUuid(String accountUuid) {
        this.accountUuid = accountUuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public LocalDate getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(LocalDate lastUsed) {
        this.lastUsed = lastUsed;
    }

    public Instant getLastActive() {
        return this.lastActive;
    }

    public void setLastActive(Instant lastActive) {
        this.lastActive = lastActive;
    }

    public GroupRights getRights() {
        return this.rights;
    }

    public void setRights(GroupRights rights) {
        this.rights = rights;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public AuditAccountAction getAction() {
        return this.action;
    }

    public void setAction(AuditAccountAction action) {
        this.action = action;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isAccountValid() {
        return this.accountValid;
    }

    public void setAccountValid(boolean accountValid) {
        this.accountValid = accountValid;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public boolean isDisconnectedNested() {
        return this.disconnectedNested;
    }

    public void setDisconnectedNested(boolean disconnectedNested) {
        this.disconnectedNested = disconnectedNested;
    }

    public boolean isNewMember() {
        return AuditAccountAction.ADD_AS_MANAGER.equals((Object)this.action) || AuditAccountAction.ADD_AS_NORMAL.equals((Object)this.action);
    }

    @Override
    public String toOmschrijving() {
        if (this.getDisplayName() == null || this.getDisplayName().equals(this.getUsername())) {
            return this.getUsername();
        }
        return this.getDisplayName() + " (" + this.getUsername() + ")";
    }
}

