/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.topicus.keyhub.servicecontract.model.auth.Account;
import nl.topicus.keyhub.servicecontract.model.certificate.Certificate;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplication;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectory;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.group.GroupClassification;
import nl.topicus.keyhub.servicecontract.model.identitysource.IdentitySource;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnit;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfile;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequest;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccount;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.webhook.Webhook;

public enum AuditRecordType {
    ACCESS_PROFILE_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Group.class)),
    ACCESS_PROFILE_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Group.class)),
    ACCESS_PROFILE_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Group.class)),
    ACCOUNT_2FA_DISABLED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class)),
    ACCOUNT_2FA_ENABLED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class)),
    ACCOUNT_ACCESS_PROFILE_DEPROVISIONED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Account.class, ProvisionedSystem.class)),
    ACCOUNT_ACCESS_PROFILE_PROVISIONED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Account.class, ProvisionedSystem.class)),
    ACCOUNT_ACTIVATION_CODE_USED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    ACCOUNT_ADDED_TO_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccessProfile.class)),
    ACCOUNT_ADDED_TO_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class)),
    ACCOUNT_ADDED_TO_ORGANIZATIONAL_UNIT(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, OrganizationalUnit.class)),
    ACCOUNT_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class, OrganizationalUnit.class)),
    ACCOUNT_DEPROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class)),
    ACCOUNT_DISABLED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    ACCOUNT_ENABLED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    ACCOUNT_GROUP_ACTIVATED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class)),
    ACCOUNT_GROUP_ACTIVATION_REASON(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class)),
    ACCOUNT_GROUP_DEPROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class)),
    ACCOUNT_GROUP_PROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class)),
    ACCOUNT_LOGIN(true, AuditRecordType.optional(Account.class, AccountDirectory.class, ClientApplication.class), AuditRecordType.required(new Class[0])),
    ACCOUNT_LOGIN_FAILED(false, AuditRecordType.optional(Account.class, AccountDirectory.class, ClientApplication.class), AuditRecordType.required(new Class[0])),
    ACCOUNT_MODIFIED_FOR_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccessProfile.class)),
    ACCOUNT_MODIFIED_FOR_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class)),
    ACCOUNT_PASSWORD_CHANGED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    ACCOUNT_PROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class)),
    ACCOUNT_PROVISIONING_DESTROYED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class)),
    ACCOUNT_PROVISIONING_INITED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class)),
    ACCOUNT_PROVISIONING_MOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class)),
    ACCOUNT_PROVISIONING_SETUP(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class)),
    ACCOUNT_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class, OrganizationalUnit.class)),
    ACCOUNT_REMOVED_FROM_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccessProfile.class)),
    ACCOUNT_REMOVED_FROM_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class)),
    ACCOUNT_REMOVED_FROM_ORGANIZATIONAL_UNIT(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, OrganizationalUnit.class)),
    ACCOUNT_REREGISTERED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    ACCOUNT_SSH_PUBLIC_KEY_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class)),
    ACCOUNT_TOKEN_SIGNED(true, AuditRecordType.optional(Account.class, Group.class), AuditRecordType.required(ClientApplication.class)),
    ACCOUNT_TOTP_OFFSET_CHANGED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class)),
    ACCOUNT_VAULT_UNLOCKED(true, AuditRecordType.optional(Account.class, ClientApplication.class), AuditRecordType.required(new Class[0])),
    ADD_GROUP_ADMIN_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ADD_GROUP_ADMIN_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ADD_GROUP_ADMIN_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ADD_GROUP_TO_ACCESS_PROFILE_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Group.class, ModificationRequest.class)),
    ADD_GROUP_TO_ACCESS_PROFILE_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Group.class, ModificationRequest.class)),
    ADD_GROUP_TO_ACCESS_PROFILE_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, Group.class, ModificationRequest.class)),
    AUDITOR_EXPORT_GENERATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(new Class[0])),
    CERTIFICATE_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Certificate.class)),
    CERTIFICATE_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Certificate.class)),
    CERTIFICATE_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Certificate.class)),
    CLIENT_ADDED_TO_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, ClientApplication.class)),
    CLIENT_ADDED_TO_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CLIENT_ADDED_TO_ORGANIZATIONAL_UNIT(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ClientApplication.class, OrganizationalUnit.class)),
    CLIENT_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CLIENT_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CLIENT_MODIFIED_FOR_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CLIENT_PERMISSION_GRANTED(false, AuditRecordType.optional(Group.class, ProvisionedSystem.class), AuditRecordType.required(ClientApplication.class)),
    CLIENT_PERMISSION_REVOKED(false, AuditRecordType.optional(Group.class, ProvisionedSystem.class), AuditRecordType.required(ClientApplication.class)),
    CLIENT_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CLIENT_REMOVED_FROM_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, ClientApplication.class)),
    CLIENT_REMOVED_FROM_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CLIENT_REMOVED_FROM_ORGANIZATIONAL_UNIT(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ClientApplication.class, OrganizationalUnit.class)),
    CLIENT_SECRET_ROTATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ClientApplication.class)),
    CREATE_GROUP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    CREATE_GROUP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    CREATE_GROUP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    CREATE_GROUP_ON_SYSTEM_ACCEPTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_GROUP_ON_SYSTEM_DECLINED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_GROUP_ON_SYSTEM_REQUESTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_PROVISIONED_NAMESPACE_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_PROVISIONED_NAMESPACE_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_PROVISIONED_NAMESPACE_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_SERVICE_ACCOUNT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_SERVICE_ACCOUNT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    CREATE_SERVICE_ACCOUNT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    DIRECTORY_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class)),
    DIRECTORY_HELPDESK_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class, Group.class)),
    DIRECTORY_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class)),
    DIRECTORY_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class)),
    DISABLE_2FA_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    DISABLE_2FA_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    DISABLE_2FA_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    ENABLE_PROFILE_ADMINISTRATION_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ENABLE_PROFILE_ADMINISTRATION_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ENABLE_PROFILE_ADMINISTRATION_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ENABLE_TECHNICAL_ADMINISTRATION_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ENABLE_TECHNICAL_ADMINISTRATION_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    ENABLE_TECHNICAL_ADMINISTRATION_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    EXTENDED_ACCESS_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    EXTENDED_ACCESS_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    EXTENDED_ACCESS_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    GRANT_ACCESS_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    GRANT_ACCESS_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    GRANT_ACCESS_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    GRANT_APPLICATION_ACCEPTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ClientApplication.class, ModificationRequest.class)),
    GRANT_APPLICATION_DECLINED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ClientApplication.class, ModificationRequest.class)),
    GRANT_APPLICATION_REQUESTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ClientApplication.class, ModificationRequest.class)),
    GRANT_CLIENT_PERMISSION_ACCEPTED(false, AuditRecordType.optional(Group.class, ProvisionedSystem.class), AuditRecordType.required(Account.class, ClientApplication.class, ModificationRequest.class)),
    GRANT_CLIENT_PERMISSION_DECLINED(false, AuditRecordType.optional(Group.class, ProvisionedSystem.class), AuditRecordType.required(Account.class, ClientApplication.class, ModificationRequest.class)),
    GRANT_CLIENT_PERMISSION_REQUESTED(false, AuditRecordType.optional(Group.class, ProvisionedSystem.class), AuditRecordType.required(Account.class, ClientApplication.class, ModificationRequest.class)),
    GRANT_GROUP_ON_SYSTEM_ACCEPTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    GRANT_GROUP_ON_SYSTEM_DECLINED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    GRANT_GROUP_ON_SYSTEM_REQUESTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    GRANT_GROUP_ON_SYSTEM_REQUEST_ACCEPTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    GRANT_GROUP_ON_SYSTEM_REQUEST_DECLINED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    GRANT_GROUP_ON_SYSTEM_REQUEST_REQUESTED(false, AuditRecordType.optional(AccessProfile.class, Group.class), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class)),
    GRANT_SERVICE_ACCOUNT_GROUP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class, ServiceAccount.class)),
    GRANT_SERVICE_ACCOUNT_GROUP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class, ServiceAccount.class)),
    GRANT_SERVICE_ACCOUNT_GROUP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ProvisionedSystem.class, ModificationRequest.class, ServiceAccount.class)),
    GROUP_ADDED_TO_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, AccessProfile.class)),
    GROUP_AUDIT_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_AUDIT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_AUTHORIZATION_CONNECTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_AUTHORIZATION_DISCONNECTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_CLASSIFICATION_ASSIGNED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, GroupClassification.class)),
    GROUP_CLASSIFICATION_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(GroupClassification.class)),
    GROUP_CLASSIFICATION_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(GroupClassification.class)),
    GROUP_CLASSIFICATION_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(GroupClassification.class)),
    GROUP_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_MOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, OrganizationalUnit.class)),
    GROUP_NESTING_CONNECTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_NESTING_DISCONNECTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_ON_SYSTEM_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ProvisionedSystem.class)),
    GROUP_ON_SYSTEM_DEPROVISIONED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ProvisionedSystem.class)),
    GROUP_ON_SYSTEM_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ProvisionedSystem.class)),
    GROUP_ON_SYSTEM_PROVISIONED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ProvisionedSystem.class)),
    GROUP_ON_SYSTEM_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ProvisionedSystem.class)),
    GROUP_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class)),
    GROUP_REMOVED_FROM_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, AccessProfile.class)),
    IDENTITY_SOURCE_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(IdentitySource.class)),
    IDENTITY_SOURCE_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(IdentitySource.class)),
    IDENTITY_SOURCE_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(IdentitySource.class)),
    INTERNAL_ACCOUNT_ACTIVATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    INTERNAL_ACCOUNT_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    INTERNAL_ACCOUNT_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    INTERNAL_ACCOUNT_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class)),
    INVALID_SIGNATURE_DETECTED(false, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(new Class[0])),
    JOIN_GROUP_ACCEPTED(false, AuditRecordType.optional(AccessProfile.class), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    JOIN_GROUP_DECLINED(false, AuditRecordType.optional(AccessProfile.class), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    JOIN_GROUP_REQUESTED(false, AuditRecordType.optional(AccessProfile.class), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    JOIN_VAULT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    JOIN_VAULT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    JOIN_VAULT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    LICENSE_KEY_UPLOADED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(new Class[0])),
    LINK_DIRECTORY_TO_ACCESS_PROFILE_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class, AccessProfile.class, ModificationRequest.class)),
    LINK_DIRECTORY_TO_ACCESS_PROFILE_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class, AccessProfile.class, ModificationRequest.class)),
    LINK_DIRECTORY_TO_ACCESS_PROFILE_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccountDirectory.class, AccessProfile.class, ModificationRequest.class)),
    MOVE_GROUPS_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, OrganizationalUnit.class, ModificationRequest.class)),
    MOVE_GROUPS_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, OrganizationalUnit.class, ModificationRequest.class)),
    MOVE_GROUPS_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, OrganizationalUnit.class, ModificationRequest.class)),
    ORGANIZATIONAL_UNIT_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, OrganizationalUnit.class)),
    ORGANIZATIONAL_UNIT_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, OrganizationalUnit.class)),
    ORGANIZATIONAL_UNIT_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, OrganizationalUnit.class)),
    PROVISIONED_SYSTEM_ADDED_TO_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_ADDED_TO_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_MODIFIED_FOR_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_REMOVED_FROM_ACCESS_PROFILE(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(AccessProfile.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_REMOVED_FROM_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    PROVISIONED_SYSTEM_UNKNOWN_ACCOUNT_DESTROYED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class)),
    REMOVE_ACCESS_PROFILE_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccessProfile.class, ModificationRequest.class)),
    REMOVE_ACCESS_PROFILE_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccessProfile.class, ModificationRequest.class)),
    REMOVE_ACCESS_PROFILE_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccessProfile.class, ModificationRequest.class)),
    REMOVE_GROUP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    REMOVE_GROUP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    REMOVE_GROUP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    REMOVE_ORGANIZATIONAL_UNIT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, OrganizationalUnit.class, ModificationRequest.class)),
    REMOVE_ORGANIZATIONAL_UNIT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, OrganizationalUnit.class, ModificationRequest.class)),
    REMOVE_ORGANIZATIONAL_UNIT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, OrganizationalUnit.class, ModificationRequest.class)),
    REMOVE_PROVISIONED_SYSTEM_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    REMOVE_PROVISIONED_SYSTEM_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    REMOVE_PROVISIONED_SYSTEM_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    RESET_PASSWORD_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    RESET_PASSWORD_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    RESET_PASSWORD_FINISHED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    RESET_PASSWORD_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    REVIEW_AUDIT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    REVIEW_AUDIT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    REVIEW_AUDIT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    REVOKE_ADMIN_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    REVOKE_ADMIN_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    REVOKE_ADMIN_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, ModificationRequest.class)),
    SERVICE_ACCOUNT_ADDED_TO_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_CREATED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_DEPROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_GROUP_DEPROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_GROUP_PROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_MODIFIED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_PASSWORD_ROTATED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_PROVISIONED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_PROVISIONING_DESTROYED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_PROVISIONING_INITED(true, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_REMOVED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SERVICE_ACCOUNT_REMOVED_FROM_GROUP(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Group.class, ProvisionedSystem.class, ServiceAccount.class)),
    SETTING_MODIFIED(false, AuditRecordType.optional(Group.class, OrganizationalUnit.class), AuditRecordType.required(new Class[0])),
    SETUP_AUTHORIZING_GROUP_CONNECT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_AUTHORIZING_GROUP_CONNECT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_AUTHORIZING_GROUP_CONNECT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_AUTHORIZING_GROUP_DISCONNECT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_AUTHORIZING_GROUP_DISCONNECT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_AUTHORIZING_GROUP_DISCONNECT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_NESTED_GROUP_CONNECT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_NESTED_GROUP_CONNECT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_NESTED_GROUP_CONNECT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_NESTED_GROUP_DISCONNECT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_NESTED_GROUP_DISCONNECT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    SETUP_NESTED_GROUP_DISCONNECT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    TRANSFER_ACCESS_PROFILE_OWNERSHIP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, AccessProfile.class, ModificationRequest.class)),
    TRANSFER_ACCESS_PROFILE_OWNERSHIP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, AccessProfile.class, ModificationRequest.class)),
    TRANSFER_ACCESS_PROFILE_OWNERSHIP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, AccessProfile.class, ModificationRequest.class)),
    TRANSFER_APPLICATION_ADMINISTRATION_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ClientApplication.class, ModificationRequest.class)),
    TRANSFER_APPLICATION_ADMINISTRATION_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ClientApplication.class, ModificationRequest.class)),
    TRANSFER_APPLICATION_ADMINISTRATION_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ClientApplication.class, ModificationRequest.class)),
    TRANSFER_APPLICATION_OWNERSHIP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ClientApplication.class, ModificationRequest.class)),
    TRANSFER_APPLICATION_OWNERSHIP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ClientApplication.class, ModificationRequest.class)),
    TRANSFER_APPLICATION_OWNERSHIP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ClientApplication.class, ModificationRequest.class)),
    TRANSFER_GROUP_ON_SYSTEM_OWNERSHIP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_GROUP_ON_SYSTEM_OWNERSHIP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_GROUP_ON_SYSTEM_OWNERSHIP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_ORGANIZATIONAL_UNIT_OWNERSHIP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, OrganizationalUnit.class, ModificationRequest.class)),
    TRANSFER_ORGANIZATIONAL_UNIT_OWNERSHIP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, OrganizationalUnit.class, ModificationRequest.class)),
    TRANSFER_ORGANIZATIONAL_UNIT_OWNERSHIP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, OrganizationalUnit.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_ADMINISTRATION_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_ADMINISTRATION_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_ADMINISTRATION_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_CONTENT_ADMINISTRATION_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_CONTENT_ADMINISTRATION_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_CONTENT_ADMINISTRATION_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_OWNERSHIP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_OWNERSHIP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_PROVISIONED_SYSTEM_OWNERSHIP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ModificationRequest.class)),
    TRANSFER_SERVICE_ACCOUNT_ADMINISTRATION_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ServiceAccount.class, ModificationRequest.class)),
    TRANSFER_SERVICE_ACCOUNT_ADMINISTRATION_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ServiceAccount.class, ModificationRequest.class)),
    TRANSFER_SERVICE_ACCOUNT_ADMINISTRATION_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ProvisionedSystem.class, ServiceAccount.class, ModificationRequest.class)),
    UPDATE_GROUP_MEMBERSHIP_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    UPDATE_GROUP_MEMBERSHIP_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    UPDATE_GROUP_MEMBERSHIP_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, Group.class, ModificationRequest.class)),
    UPDATE_LICENSE_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ModificationRequest.class)),
    UPDATE_LICENSE_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ModificationRequest.class)),
    UPDATE_LICENSE_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(ModificationRequest.class)),
    VAULT_ACCESS_RESTORED(false, AuditRecordType.optional(Group.class), AuditRecordType.required(Account.class)),
    VAULT_EXPORTED(false, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(new Class[0])),
    VAULT_PERSONAL_RESET(false, AuditRecordType.optional(Account.class, ClientApplication.class), AuditRecordType.required(new Class[0])),
    VAULT_PERSONAL_SETUP(false, AuditRecordType.optional(Account.class, ClientApplication.class), AuditRecordType.required(new Class[0])),
    VAULT_RECORD_CREATED(false, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(VaultRecord.class)),
    VAULT_RECORD_MODIFIED(false, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(VaultRecord.class)),
    VAULT_RECORD_MOVED_COPIED_SHARED(false, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(VaultRecord.class)),
    VAULT_RECORD_READ(true, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(VaultRecord.class)),
    VAULT_RECORD_REMOVED(false, AuditRecordType.optional(Account.class, ClientApplication.class, Group.class), AuditRecordType.required(VaultRecord.class)),
    VAULT_RECOVERED(false, AuditRecordType.optional(Account.class, Group.class), AuditRecordType.required(new Class[0])),
    VERIFY_INTERNAL_ACCOUNT_ACCEPTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class, ModificationRequest.class)),
    VERIFY_INTERNAL_ACCOUNT_DECLINED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class, ModificationRequest.class)),
    VERIFY_INTERNAL_ACCOUNT_REQUESTED(false, AuditRecordType.optional(new Class[0]), AuditRecordType.required(Account.class, AccountDirectory.class, ModificationRequest.class)),
    WEBHOOK_CREATED(false, AuditRecordType.optional(Account.class, AccountDirectory.class, ClientApplication.class, Group.class, ProvisionedSystem.class, ServiceAccount.class), AuditRecordType.required(Webhook.class)),
    WEBHOOK_MODIFIED(false, AuditRecordType.optional(Account.class, AccountDirectory.class, ClientApplication.class, Group.class, ProvisionedSystem.class, ServiceAccount.class), AuditRecordType.required(Webhook.class)),
    WEBHOOK_REMOVED(false, AuditRecordType.optional(Account.class, AccountDirectory.class, ClientApplication.class, Group.class, ProvisionedSystem.class, ServiceAccount.class), AuditRecordType.required(Webhook.class));

    private boolean daily;
    private Set<Class<?>> context;
    private Set<Class<?>> requiredContext;
    private Set<Class<?>> optionalContext;

    private AuditRecordType(boolean daily, Set<Class<?>> optionalContext, Set<Class<?>> requiredContext) {
        this.daily = daily;
        this.requiredContext = Collections.unmodifiableSet(requiredContext);
        this.optionalContext = Collections.unmodifiableSet(optionalContext);
        HashSet fullContext = new HashSet();
        fullContext.addAll(this.requiredContext);
        fullContext.addAll(this.optionalContext);
        this.context = Collections.unmodifiableSet(fullContext);
    }

    public boolean isDailyUse() {
        return this.daily;
    }

    public Set<Class<?>> getContext() {
        return this.context;
    }

    public Set<Class<?>> getOptionalContext() {
        return this.optionalContext;
    }

    public Set<Class<?>> getRequiredContext() {
        return this.requiredContext;
    }

    public static List<AuditRecordType> getTypesNotForDailyUse() {
        ArrayList<AuditRecordType> ret = new ArrayList<AuditRecordType>();
        for (AuditRecordType curType : AuditRecordType.values()) {
            if (curType.isDailyUse()) continue;
            ret.add(curType);
        }
        return ret;
    }

    private static Set<Class<?>> required(Class<?> ... types) {
        return AuditRecordType.toSet(types);
    }

    private static Set<Class<?>> optional(Class<?> ... types) {
        return AuditRecordType.toSet(types);
    }

    private static Set<Class<?>> toSet(Class<?> ... types) {
        return new HashSet(Arrays.asList(types));
    }
}

