/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.audit;

import java.util.Arrays;
import java.util.List;
import nl.topicus.keyhub.servicecontract.model.group.GroupRights;

public enum AuditAccountAction {
    APPROVE,
    ADD_AS_MANAGER,
    ADD_AS_NORMAL,
    CHANGE_TO_MANAGER,
    CHANGE_TO_NORMAL,
    REMOVE,
    CONNECT_NESTED;


    public static List<AuditAccountAction> getOptions(GroupRights rights, boolean isAdminGroup, boolean isDisconnectedNested) {
        AuditAccountAction removeAction;
        if (isAdminGroup) {
            return Arrays.asList(APPROVE, REMOVE);
        }
        AuditAccountAction auditAccountAction = removeAction = isDisconnectedNested ? CONNECT_NESTED : REMOVE;
        if (rights == GroupRights.MANAGER) {
            return Arrays.asList(APPROVE, CHANGE_TO_NORMAL, removeAction);
        }
        if (rights == GroupRights.NORMAL) {
            return Arrays.asList(APPROVE, CHANGE_TO_MANAGER, removeAction);
        }
        throw new IllegalStateException();
    }
}

