/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.AllowedEnumValues;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.parser.errors.ParseArgumentsMissingException;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import nl.topicus.keyhub.cli.print.SimpleValuePrinter;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.vault.AbstractVaultCommand;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordColor;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordPrimer;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordSecrets;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordWarningPeriod;
import nl.topicus.keyhub.servicecontract.model.vault.VaultSecretType;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

@Command(name="write", description="Creates or updates a record in a vault.")
public class VaultWriteCommand
extends AbstractVaultCommand {
    @Option(name={"--record"}, description="The record to update (UUID).")
    @SilentOnce
    @ExactLength(length=36)
    private UUID recordUuid;
    @Option(name={"--name"}, description="The name of the record.")
    @SilentOnce
    private String name;
    @Option(name={"--color"}, description="The color of the record.")
    @AllowedEnumValues(value=VaultRecordColor.class)
    @SilentOnce
    private VaultRecordColor color;
    @Option(name={"--url"}, description="The URL to be set on the record.")
    @SilentOnce
    private String url;
    @Option(name={"--username"}, description="The username to be set on the record.")
    @SilentOnce
    private String username;
    @Option(name={"--filename"}, description="The filename to be set on a record of type FILE.")
    @SilentOnce
    private String filename;
    @Option(name={"--password"}, description="The password to store with the record. Use '-' for stdin. Use an empty value to remove the password from an existing record.")
    @SilentOnce
    private String password;
    @Option(name={"--totp"}, description="The TOTP secret to store with the record. Use '-' for stdin. Use an empty value to remove the TOTP from an existing record.")
    @SilentOnce
    private String totp;
    @Option(name={"--file"}, description="The file to store with the record. Use '-' for stdin. Use an empty value to remove the file from an existing record.")
    @SilentOnce
    private String file;
    @Option(name={"--comment"}, description="A comment on the record. Use '-' for stdin. Use an empty value to remove the comment from an existing record.")
    @SilentOnce
    private String comment;
    @Option(name={"--enddate"}, description="The end date for the record, formatted as yyyy-mm-dd.")
    @SilentOnce
    private LocalDate endDate;
    @Option(name={"--warningperiod"}, description="How far in advance Topicus KeyHub should start displaying expiry warnings.")
    @AllowedEnumValues(value=VaultRecordWarningPeriod.class)
    @SilentOnce
    private VaultRecordWarningPeriod warningPeriod;

    @Override
    protected void perform(URI vaultHolderUri) {
        VaultRecordSecrets secrets;
        VaultRecord record;
        if (this.filename == null && !Strings.isNullOrEmpty(this.file) && !this.file.equals("-")) {
            this.filename = Paths.get(this.file, new String[0]).getFileName().toString();
        }
        if (this.recordUuid != null) {
            record = this.vaultClient().getRecord(vaultHolderUri, "uuid='" + String.valueOf(this.recordUuid) + "'");
            if (this.name != null) {
                record.setName(this.name);
            }
            if (this.color != null) {
                record.setColor(this.color);
            }
            if (this.url != null) {
                record.setUrl(this.url);
            }
            if (this.username != null) {
                record.setUsername(this.username);
            }
            if (this.filename != null) {
                record.setFilename(this.filename);
            }
            if (this.warningPeriod != null) {
                record.setWarningPeriod(this.warningPeriod);
            }
            if (this.endDate != null) {
                record.setEndDate(this.endDate);
            }
            secrets = record.getAdditionalObjects(VaultRecordResource.SECRETS);
        } else {
            ArrayList<String> missing = new ArrayList<String>();
            if (this.name == null) {
                missing.add("--name");
            }
            if (this.warningPeriod != null && this.endDate == null) {
                missing.add("--enddate");
            }
            if (this.filename == null && !Strings.isNullOrEmpty(this.file)) {
                missing.add("--filename");
            }
            if (!missing.isEmpty()) {
                throw new ParseArgumentsMissingException(missing);
            }
            if (this.endDate != null && this.warningPeriod == null) {
                this.warningPeriod = VaultRecordWarningPeriod.AT_EXPIRATION;
            }
            record = new VaultRecord();
            record.setName(this.name);
            record.setColor(this.color == null ? VaultRecordColor.NONE : this.color);
            record.setUrl(this.url);
            record.setUsername(this.username);
            record.setFilename(this.filename);
            record.setEndDate(this.endDate);
            record.setWarningPeriod(this.warningPeriod);
            secrets = new VaultRecordSecrets();
        }
        if (this.password != null || this.totp != null || this.file != null || this.comment != null) {
            secrets.setPassword(this.readSecretOrDefault(this.password, VaultSecretType.PASSWORD, secrets.getPassword()));
            secrets.setFile(this.readSecretOrDefault(this.file, VaultSecretType.FILE, secrets.getFile()));
            secrets.setComment(this.readSecretOrDefault(this.comment, VaultSecretType.COMMENT, secrets.getComment()));
            if (this.totp != null) {
                secrets.setTotpKey(this.readSecret(this.totp, VaultSecretType.TOTP));
            }
            record.getAdditionalObjects().put(VaultRecordResource.SECRETS.getName(), secrets);
        } else if (record.self() == null) {
            throw new ParseArgumentsMissingException(Arrays.asList("--password", "--totp", "--file", "--comment"));
        }
        if (Strings.isNullOrEmpty(secrets.getFile())) {
            record.setFilename(null);
        }
        record = this.vaultClient().writeRecord(vaultHolderUri, record);
        this.print(record, SimpleValuePrinter.of(VaultRecordPrimer::getUuid));
    }

    private String readSecretOrDefault(String secret, VaultSecretType type, String defaultValue) {
        if (secret == null) {
            return defaultValue;
        }
        if (secret.equals("")) {
            return null;
        }
        return this.readSecret(secret, type);
    }

    private String readSecret(String secret, VaultSecretType type) {
        try {
            String ret;
            if (secret.equals("-")) {
                byte[] data = ByteStreams.toByteArray(this.env().in());
                ret = type.equals((Object)VaultSecretType.FILE) ? Base64.getEncoder().encodeToString(data) : new String(data, StandardCharsets.UTF_8).trim();
            } else {
                ret = type.equals((Object)VaultSecretType.FILE) ? Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get(secret, new String[0]))) : secret;
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

