/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import com.github.rvesse.airline.annotations.restrictions.Required;
import java.net.URI;
import java.util.UUID;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.vault.AbstractVaultCommand;
import nl.topicus.keyhub.servicecontract.model.vault.MoveVaultRecordAction;

@Command(name="share", description="Shares a record from one vault with another.")
public class VaultShareCommand
extends AbstractVaultCommand {
    @Option(name={"--record"}, description="The record to share (UUID).")
    @Required
    @SilentOnce
    @ExactLength(length=36)
    private UUID recordUuid;
    @Option(name={"--target-account"}, description="Share the selected record with the targeted personal vault (UUID).")
    @RequireOnlyOne(tag="target")
    @SilentOnce
    @ExactLength(length=36)
    private UUID targetAccount;
    @Option(name={"--target-group"}, description="Share the selected record with the targeted group vault  (UUID).")
    @RequireOnlyOne(tag="target")
    @SilentOnce
    @ExactLength(length=36)
    private UUID targetGroup;

    @Override
    protected void perform(URI vaultHolderUri) {
        this.vaultClient().transferRecord(vaultHolderUri, this.recordUuid, MoveVaultRecordAction.SHARE, this.targetAccount, this.targetGroup);
    }
}

