/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import nl.topicus.keyhub.cli.print.SimpleValuePrinter;
import nl.topicus.keyhub.cli.print.VaultRecordPrinter;
import nl.topicus.keyhub.cli.print.VaultRecordSecretPrinter;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.vault.AbstractVaultCommand;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordSecrets;
import nl.topicus.keyhub.servicecontract.model.vault.VaultSecretType;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

@Command(name="read", description="Reads a record in a vault.")
public class VaultReadCommand
extends AbstractVaultCommand {
    @Option(name={"--record"}, description="The record to read (UUID).")
    @RequireOnlyOne(tag="query")
    @SilentOnce
    @ExactLength(length=36)
    private UUID recordUuid;
    @Option(name={"--query"}, description="A query for the record to read.")
    @RequireOnlyOne(tag="query")
    @SilentOnce
    private String query;
    @Option(name={"--type"}, description="The type of secret to display.")
    @SilentOnce
    private VaultSecretType type;

    @Override
    protected void perform(URI vaultHolderUri) {
        VaultRecord record = this.vaultClient().getRecord(vaultHolderUri, (String)(this.recordUuid == null ? this.query : "uuid='" + String.valueOf(this.recordUuid) + "'"));
        if (record.getTypes().size() == 1) {
            this.type = record.getTypes().iterator().next();
        }
        if (this.isDetailOutput()) {
            this.print(List.of(record), new VaultRecordPrinter(false));
        } else if (this.type == null || this.isJsonOutput()) {
            this.print(record, new VaultRecordSecretPrinter());
        } else {
            VaultRecordSecrets secrets = record.getAdditionalObjects(VaultRecordResource.SECRETS);
            String secret = secrets.get(this.type);
            if (this.type.equals((Object)VaultSecretType.FILE) && this.isPlainOutput()) {
                try {
                    this.env().out().write(Base64.getDecoder().decode(secret));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.print(record, SimpleValuePrinter.of(x -> secret));
            }
        }
    }
}

