/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import com.github.rvesse.airline.annotations.restrictions.Required;
import java.net.URI;
import java.util.UUID;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.vault.AbstractVaultCommand;
import nl.topicus.keyhub.servicecontract.model.vault.MoveVaultRecordAction;

@Command(name="mv", description="Moves a record from one vault to another.")
public class VaultMoveCommand
extends AbstractVaultCommand {
    @Option(name={"--record"}, description="The record to move (UUID).")
    @Required
    @SilentOnce
    @ExactLength(length=36)
    private UUID recordUuid;
    @Option(name={"--target-account"}, description="Move the selected record to the targeted personal vault (UUID).")
    @RequireOnlyOne(tag="target")
    @SilentOnce
    @ExactLength(length=36)
    private UUID targetAccount;
    @Option(name={"--target-group"}, description="Move the selected record to the targeted group vault (UUID).")
    @RequireOnlyOne(tag="target")
    @SilentOnce
    @ExactLength(length=36)
    private UUID targetGroup;

    @Override
    protected void perform(URI vaultHolderUri) {
        this.vaultClient().transferRecord(vaultHolderUri, this.recordUuid, MoveVaultRecordAction.MOVE, this.targetAccount, this.targetGroup);
    }
}

