/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.File;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.base.Strings;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDate;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.vault.AbstractVaultCommand;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordColor;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordSecrets;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordWarningPeriod;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

@Command(name="import", description="Imports all records from a CSV file into a vault. The CSV file must contain the following fields: name,color,url,username,password,totp,enddate,warningperiod,comment. See the manual for more information on the expected format.")
public class VaultImportCommand
extends AbstractVaultCommand {
    @Option(name={"--file"}, description="The CSV file to import.")
    @File(mustExist=true, readable=true)
    @Required
    @SilentOnce
    private Path file;

    @Override
    protected void perform(URI vaultHolderUri) {
        long total = this.processCsv(vaultHolderUri, false, 0L);
        this.credentials().aquireAccessToken();
        this.processCsv(vaultHolderUri, true, total);
    }

    private long processCsv(URI vaultHolderUri, boolean write, long total) {
        long curLine = 0L;
        String[] line = null;
        try (BufferedReader input = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);
             CSVReader csvReader = new CSVReaderBuilder(input).build();){
            while ((line = csvReader.readNext()) != null) {
                ++curLine;
                if (line.length != 9) {
                    throw new CsvValidationException("Invalid number of columns, must be 9");
                }
                if (curLine == 1L && "name".equals(line[0]) && "color".equals(line[1]) && "url".equals(line[2])) continue;
                VaultRecord record = new VaultRecord();
                VaultRecordSecrets secrets = new VaultRecordSecrets();
                record.getAdditionalObjects().put(VaultRecordResource.SECRETS.getName(), secrets);
                record.setName(line[0]);
                if (Strings.isNullOrEmpty(record.getName()) || record.getName().length() > 255) {
                    throw new CsvValidationException("Name must be between 1 and 255 characters");
                }
                record.setColor(Strings.isNullOrEmpty(line[1]) ? VaultRecordColor.NONE : VaultRecordColor.valueOf(line[1]));
                record.setUrl(Strings.emptyToNull(line[2]));
                record.setUsername(Strings.emptyToNull(line[3]));
                if (record.getUsername() != null && record.getUsername().length() > 255) {
                    throw new CsvValidationException("Username must be at most 255 characters");
                }
                secrets.setPassword(Strings.emptyToNull(line[4]));
                secrets.setTotpKey(Strings.emptyToNull(line[5]));
                if (!Strings.isNullOrEmpty(line[6])) {
                    record.setEndDate(LocalDate.parse(line[6]));
                    record.setWarningPeriod(VaultRecordWarningPeriod.valueOf(line[7]));
                }
                secrets.setComment(Strings.emptyToNull(line[8]));
                if (!secrets.isSetForWriting()) {
                    throw new CsvValidationException("No secrets given, either password, totp and/or comment is required");
                }
                if (!write) continue;
                record = this.vaultClient().writeRecord(vaultHolderUri, record);
                if (!this.verbose) continue;
                this.env().out().println("Line " + curLine + "/" + total + " (" + record.getName() + ") -> " + record.getUuid());
            }
        }
        catch (CsvValidationException | IOException | IllegalArgumentException e) {
            throw new RuntimeException("Error reading csv at line " + curLine, e);
        }
        return curLine;
    }
}

