/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.vault.AbstractVaultCommand;
import org.apache.commons.io.IOUtils;

@Command(name="export", description="Exports all records from a vault into a CSV file. The CSV file will contain the following fields: name,color,url,username,password,totp,enddate,warningperiod,comment.")
public class VaultExportCommand
extends AbstractVaultCommand {
    @Option(name={"--file"}, description="Write the contents to the given file.")
    @File(mustExist=false, writable=true)
    @SilentOnce
    private Path file;

    @Override
    protected void perform(URI vaultHolderUri) {
        URI exportURI = this.vaultClient().startExport(vaultHolderUri);
        OutputStream outStream = null;
        boolean close = false;
        try (InputStream in = this.vaultClient().export(exportURI);){
            if (this.file == null) {
                outStream = this.env().out();
            } else {
                close = true;
                outStream = Files.newOutputStream(this.file, new OpenOption[0]);
            }
            IOUtils.copy(in, outStream);
            outStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (close && outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

