/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.vault;

import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import java.net.URI;
import java.util.UUID;
import nl.topicus.keyhub.cli.AbstractKeyHubOutputCommand;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.cli.storage.StoredCredential;
import nl.topicus.keyhub.servicecontract.model.group.Group;

public abstract class AbstractVaultCommand
extends AbstractKeyHubOutputCommand {
    @Option(name={"--personal"}, description="Use your personal vault. Can only be used when a user is authenticated.")
    @RequireOnlyOne(tag="vault")
    @SilentOnce
    private boolean personal;
    @Option(name={"--client"}, description="Use the client's vault. Can only be used when a client is authenticated.")
    @RequireOnlyOne(tag="vault")
    @SilentOnce
    private boolean client;
    @Option(name={"--group"}, description="Use the vault for the given group (UUID).")
    @RequireOnlyOne(tag="vault")
    @SilentOnce
    @ExactLength(length=36)
    private UUID group;

    @Override
    protected void doRun() {
        URI vaultHolderUri;
        this.credentials().assertAuthenticatedToKeyHub();
        StoredCredential credential = this.credentials().getActiveCredential();
        if (this.client && !credential.isClientCredentialsGrant()) {
            throw new IllegalStateException("--client can only be used when logged in with client credentials");
        }
        if (this.personal && credential.isClientCredentialsGrant()) {
            throw new IllegalStateException("--personal can only be used when logged in with a user account");
        }
        if (credential.getAuthPartyUri() == null) {
            throw new IllegalStateException("CLI not logged in");
        }
        if (this.client || this.personal) {
            vaultHolderUri = URI.create(credential.getAuthPartyUri());
        } else {
            Group groupInfo = this.groupClient().get(this.group);
            vaultHolderUri = groupInfo.self().getHref();
        }
        this.perform(vaultHolderUri);
    }

    protected abstract void perform(URI var1);
}

