/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.types;

import com.github.rvesse.airline.types.ConvertResult;
import com.github.rvesse.airline.types.DefaultTypeConverter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public class KeyHubCLITypeConverter
extends DefaultTypeConverter {
    @Override
    public Object convert(String name, Class<?> type, String value) {
        KeyHubCLITypeConverter.checkArguments(name, type, value);
        if (Path.class.isAssignableFrom(type)) {
            Path ret = Paths.get(value, new String[0]);
            return ret;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            LocalDate ret = LocalDate.parse(value);
            return ret;
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            LocalTime ret = LocalTime.parse(value);
            return ret;
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            LocalDateTime ret = LocalDateTime.parse(value);
            return ret;
        }
        if (Instant.class.isAssignableFrom(type)) {
            Instant ret = Instant.parse(value);
            return ret;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            ZonedDateTime ret = ZonedDateTime.parse(value);
            return ret;
        }
        if (Enum.class.isAssignableFrom(type)) {
            ConvertResult result = this.tryConvertFromValueOf(name, type, value);
            if (result.wasSuccessful()) {
                return result.getConvertedValue();
            }
            result = this.tryConvertFromValueOf(name, type, value.toUpperCase());
            if (result.wasSuccessful()) {
                return result.getConvertedValue();
            }
        }
        return super.convert(name, type, value);
    }
}

