/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.storage;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import nl.topicus.keyhub.cli.ServiceAccess;
import nl.topicus.keyhub.cli.storage.StoredCredentials;

public class StorageEngine
implements ServiceAccess {
    private Path getStoragePath() throws IOException {
        String configDir = System.getProperty("keyhub.config");
        Path dir = configDir == null ? Paths.get(System.getProperty("user.home"), ".keyhub") : Paths.get(configDir, new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    public StoredCredentials readCredentials() {
        StoredCredentials storedCredentials;
        block8: {
            InputStream fis = Files.newInputStream(this.getStoragePath().resolve("credentials.json"), new OpenOption[0]);
            try {
                storedCredentials = this.objectMapper().readValue(fis, StoredCredentials.class);
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            fis.close();
        }
        return storedCredentials;
    }

    public void writeCredentials(StoredCredentials credentials) {
        try {
            Path credentialsFile = this.getStoragePath().resolve("credentials.json");
            try (OutputStream fos = Files.newOutputStream(credentialsFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                this.objectMapper().writeValue(fos, (Object)credentials);
            }
            PosixFileAttributeView view = Files.getFileAttributeView(credentialsFile, PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                view.setPermissions(ImmutableSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void wipe() {
        try {
            Files.deleteIfExists(this.getStoragePath().resolve("credentials.json"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

