/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import com.google.common.base.Strings;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import nl.topicus.cobra.restcontract.http.RequestRange;
import nl.topicus.cobra.restcontract.model.ErrorReport;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.keyhub.cli.rest.AbstractRestClient;
import nl.topicus.keyhub.cli.storage.StoredCredential;
import nl.topicus.keyhub.servicecontract.model.KeyHubError;
import nl.topicus.keyhub.servicecontract.model.vault.MoveVaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.MoveVaultRecordAction;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultSecretType;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

public class VaultRestClient
extends AbstractRestClient {
    private static final GenericType<LinkableWrapper<VaultRecord>> WRAPPER_TYPE = new GenericType<LinkableWrapper<VaultRecord>>(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VaultRecord> getVault(URI holderUri) {
        Response response = null;
        try {
            UriBuilder vaultUri = UriBuilder.fromUri(holderUri).path("vault").path("record").queryParam("additional", KeyHubCrudRestResource.AUDIT.getName()).queryParam("additional", VaultRecordResource.VAULTHOLDER.getName()).queryParam("additional", VaultRecordResource.SHARE_SUMMARY.getName()).queryParam("additional", VaultRecordResource.PASSWORD_METADATA.getName());
            List<VaultRecord> list = this.readAll(vaultUri.build(new Object[0]), WRAPPER_TYPE, true);
            return list;
        }
        finally {
            this.close(response);
        }
    }

    /*
     * Loose catch block
     */
    public VaultRecord getRecord(URI holderUri, String query) {
        Serializable report;
        Response response = null;
        URI recordUri = UriBuilder.fromUri(holderUri).path("vault").path("record").queryParam("q", "{query}").queryParam("additional", KeyHubCrudRestResource.AUDIT.getName()).queryParam("additional", VaultRecordResource.VAULTHOLDER.getName()).queryParam("additional", VaultRecordResource.SHARE_SUMMARY.getName()).queryParam("additional", VaultRecordResource.PASSWORD_METADATA.getName()).queryParam("additional", VaultRecordResource.SECRETS.getName()).build(query);
        response = this.absolute(recordUri).header("topicus-Vault-session", this.credentials().getVaultSession(true)).header("Range", new RequestRange(0L, 1L)).get();
        if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            ErrorReport report2 = this.read(response, ErrorReport.class);
            if (KeyHubError.VAULT_NOT_UNLOCKED.name().equals(report2.getApplicationError())) {
                throw new IllegalStateException("Vault not unlocked.");
            }
            throw new IllegalStateException("Unexpected error: " + report2.getApplicationError());
        }
        if (response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
            report = this.read(response, ErrorReport.class);
            if (KeyHubError.VAULT_ACTIVATION_REQUIRED.name().equals(report.getApplicationError())) {
                throw new IllegalStateException("To read vault records for this group, the group must first be activated.");
            }
        }
        if (response.getStatus() != Response.Status.PARTIAL_CONTENT.getStatusCode()) {
            throw this.error(response);
        }
        report = this.readFirst(response, VaultRecord.class);
        this.close(response);
        return report;
        {
            catch (NoSuchElementException e) {
                try {
                    throw new IllegalStateException("No record with " + query + " exists.", e);
                }
                catch (Throwable throwable) {
                    this.close(response);
                    throw throwable;
                }
            }
        }
    }

    public VaultRecord writeRecord(URI holderUri, VaultRecord record) {
        if (record.self() == null) {
            URI recordUri = UriBuilder.fromUri(holderUri).path("vault").path("record").build(new Object[0]);
            return this.readFirst(this.absolute(recordUri).header("topicus-Vault-session", this.credentials().getVaultSession(true)).post(this.json(new LinkableWrapper<VaultRecord>(record))), VaultRecord.class);
        }
        return this.read(this.absolute(record.self().getHref()).header("topicus-Vault-session", this.credentials().getVaultSession(true)).put(this.json(record)), VaultRecord.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(URI holderUri, UUID recordUuid) {
        Response response = null;
        try {
            VaultRecord record = this.fetchRecord(holderUri, recordUuid);
            response = this.absolute(record.self().getHref()).delete();
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
    }

    public void transferRecord(URI holderUri, UUID recordUuid, MoveVaultRecordAction action, UUID targetAccount, UUID targetGroup) {
        VaultRecord record = this.fetchRecord(holderUri, recordUuid);
        MoveVaultRecord move = new MoveVaultRecord();
        move.setAction(action);
        move.setAccount(targetAccount == null ? null : this.accountClient().get(targetAccount));
        move.setGroup(targetGroup == null ? null : this.groupClient().get(targetGroup));
        URI recordUri = UriBuilder.fromUri(record.self().getHref()).path("move").build(new Object[0]);
        this.doTransferRecord(move, recordUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doTransferRecord(MoveVaultRecord move, URI recordUri) {
        Response response;
        block6: {
            boolean bl;
            response = null;
            try {
                response = this.absolute(recordUri).header("topicus-Vault-session", this.credentials().getVaultSession(true)).post(this.json(move));
                Optional<Boolean> retry = this.retryWithReAuth(response, () -> this.doTransferRecord(move, recordUri));
                if (!retry.isPresent()) break block6;
                bl = retry.get();
            }
            catch (Throwable throwable) {
                this.close(response);
                throw throwable;
            }
            this.close(response);
            return bl;
        }
        if (response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
            ErrorReport report = this.read(response, ErrorReport.class);
            if (KeyHubError.VAULT_ACTIVATION_REQUIRED.name().equals(report.getApplicationError())) {
                throw new IllegalStateException("To read vault records for this group, the group must first be activated.");
            }
        }
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            throw this.error(response);
        }
        boolean bl = true;
        this.close(response);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VaultRecord fetchRecord(URI holderUri, UUID recordUuid) {
        Response response = null;
        VaultRecord record = null;
        try {
            URI recordUri = UriBuilder.fromUri(holderUri).path("vault").path("record").queryParam("q", "{query}").build("uuid='" + String.valueOf(recordUuid) + "'");
            response = this.absolute(recordUri).header("Range", new RequestRange(0L, 1L)).get();
            if (response.getStatus() != Response.Status.PARTIAL_CONTENT.getStatusCode()) {
                throw this.error(response);
            }
            try {
                record = this.readFirst(response, VaultRecord.class);
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("No record with uuid='" + String.valueOf(recordUuid) + "' exists.", e);
            }
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
        return record;
    }

    public List<VaultRecord> query(String name, UUID uuid, String matches, String query, VaultSecretType type) {
        UriBuilder uriBuilder = this.resolve("/vaultrecord").queryParam("additional", VaultRecordResource.VAULTHOLDER.getName()).queryParam("additional", VaultRecordResource.SHARE_SUMMARY.getName()).queryParam("additional", VaultRecordResource.PASSWORD_METADATA.getName());
        StoredCredential credential = this.credentials().getActiveCredential();
        if (credential.isClientCredentialsGrant()) {
            Long clientId = credential.getAuthPartyId();
            uriBuilder = uriBuilder.queryParam("accessibleByClient", clientId);
        } else {
            Long accountId = credential.getAuthPartyId();
            uriBuilder = uriBuilder.queryParam("accessibleByAccount", accountId);
        }
        if (name != null) {
            uriBuilder = uriBuilder.queryParam("name", "{name}").resolveTemplate("name", name);
        }
        if (uuid != null) {
            uriBuilder = uriBuilder.queryParam("uuid", "{uuid}").resolveTemplate("uuid", uuid);
        }
        if (!Strings.isNullOrEmpty(matches)) {
            uriBuilder = uriBuilder.queryParam("nameContains", "{matches}").resolveTemplate("matches", matches);
        }
        if (query != null) {
            uriBuilder = uriBuilder.queryParam("q", "{query}").resolveTemplate("query", query);
        }
        if (type != null) {
            uriBuilder = uriBuilder.queryParam("type", new Object[]{type});
        }
        uriBuilder = uriBuilder.queryParam("sort", "asc-vaultName", "asc-name");
        return this.readAll(uriBuilder.build(new Object[0]), WRAPPER_TYPE);
    }

    public URI startExport(URI vaultHolderUri) {
        Response response;
        block5: {
            block4: {
                URI uRI;
                response = null;
                try {
                    UriBuilder builder = UriBuilder.fromUri(vaultHolderUri).path("vault/record/export").queryParam("sort", "asc-name");
                    response = this.absolute(builder.build(new Object[0])).header("topicus-Vault-session", this.credentials().getVaultSession(true)).method("POST");
                    Optional<URI> ret = this.retryWithReAuth(response, () -> this.startExport(vaultHolderUri));
                    if (!ret.isPresent()) break block4;
                    uRI = ret.get();
                }
                catch (Throwable throwable) {
                    this.close(response);
                    throw throwable;
                }
                this.close(response);
                return uRI;
            }
            if (Response.Status.ACCEPTED.getStatusCode() != response.getStatus()) break block5;
            URI uRI = URI.create(response.getHeaderString("Location"));
            this.close(response);
            return uRI;
        }
        throw this.error(response);
    }

    public InputStream export(URI exportURI) {
        Response response = this.restClientBuilder().getClient().target(UriBuilder.fromUri(this.credentials().getActiveCredential().getUri()).path(exportURI.getPath()).replaceQuery(exportURI.getQuery()).build(new Object[0])).request("text/csv").get();
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return response.readEntity(InputStream.class);
        }
        throw this.error(response);
    }
}

