/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import nl.topicus.keyhub.cli.ServiceAccess;

public class RequestLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
ServiceAccess {
    private static final String REQUEST_START = "request-start";

    @Override
    public void filter(ClientRequestContext requestContext) {
        this.env().vlog("Start of client request: " + requestContext.getMethod() + " on " + requestContext.getUri().toASCIIString());
        long start = System.currentTimeMillis();
        requestContext.setProperty(REQUEST_START, start);
    }

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        long start = (Long)requestContext.getProperty(REQUEST_START);
        this.env().vlog(String.format("End of client request (%dms): %s on %s, status %d", System.currentTimeMillis() - start, requestContext.getMethod(), requestContext.getUri().toASCIIString(), responseContext.getStatus()));
    }
}

