/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import com.google.common.base.Strings;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import nl.topicus.keyhub.cli.rest.AbstractRestClient;
import nl.topicus.keyhub.servicecontract.model.SegmentedLinkableWrapper;
import nl.topicus.keyhub.servicecontract.model.group.Group;

public class GroupRestClient
extends AbstractRestClient {
    private static final GenericType<SegmentedLinkableWrapper<Group>> WRAPPER_TYPE = new GenericType<SegmentedLinkableWrapper<Group>>(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group get(UUID uuid) {
        Group group;
        Response response = null;
        try {
            response = this.absolute(this.resolve("group").queryParam("uuid", "{uuid}").resolveTemplate("uuid", uuid).build(new Object[0])).get();
            SegmentedLinkableWrapper<Group> groups = this.read(response, WRAPPER_TYPE);
            if (groups.getItems().isEmpty()) {
                throw new NoSuchElementException("No group with UUID '" + String.valueOf(uuid) + "' exists or permission denied.");
            }
            group = groups.getFirstAs(Group.class);
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
        return group;
    }

    public List<Group> query(String name, UUID uuid, String matches, String query, Long accountId) {
        UriBuilder uriBuilder = this.resolve("/group");
        if (name != null) {
            uriBuilder = uriBuilder.queryParam("name", "{name}").resolveTemplate("name", name);
        }
        if (uuid != null) {
            uriBuilder = uriBuilder.queryParam("uuid", "{uuid}").resolveTemplate("uuid", uuid);
        }
        if (!Strings.isNullOrEmpty(matches)) {
            uriBuilder = uriBuilder.queryParam("nameContains", "{matches}").resolveTemplate("matches", matches);
        }
        if (query != null) {
            uriBuilder = uriBuilder.queryParam("q", "{query}").resolveTemplate("query", query);
        }
        if (accountId != null) {
            uriBuilder = uriBuilder.queryParam("containsAccount", accountId);
        }
        uriBuilder = uriBuilder.queryParam("sort", "asc-name");
        return this.readAll(uriBuilder.build(new Object[0]), WRAPPER_TYPE);
    }
}

