/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import nl.topicus.cobra.marshalling.CobraAnnotationIntrospector;
import nl.topicus.cobra.marshalling.CobraHandlerInstantiator;
import nl.topicus.cobra.marshalling.CobraJacksonModule;
import nl.topicus.cobra.marshalling.CobraJodaModule;
import nl.topicus.keyhub.cli.rest.JacksonObjectMapperProvider;
import nl.topicus.keyhub.cli.rest.RequestLoggingFilter;
import nl.topicus.keyhub.servicecontract.spi.KeyHubContractService;

public class CliRestClientBuilder {
    private Client client;
    private ObjectMapper mapper;

    public void init() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
        this.mapper.setHandlerInstantiator(new CobraHandlerInstantiator(new KeyHubContractService()));
        this.mapper.setAnnotationIntrospector(new CobraAnnotationIntrospector());
        this.mapper.setTimeZone(TimeZone.getDefault());
        this.mapper.registerModule(new CobraJacksonModule());
        this.mapper.registerModule(new CobraJodaModule());
        this.mapper.registerModule(new JavaTimeModule());
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.register(new RequestLoggingFilter());
        clientBuilder.register(new JacksonObjectMapperProvider(this.mapper));
        clientBuilder.register(JacksonXmlBindJsonProvider.class);
        clientBuilder.connectTimeout(30L, TimeUnit.SECONDS);
        clientBuilder.readTimeout(1L, TimeUnit.MINUTES);
        this.client = clientBuilder.build();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Client getClient() {
        return this.client;
    }
}

