/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.device.DeviceAuthorizationRequest;
import com.nimbusds.oauth2.sdk.device.DeviceAuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.device.DeviceCode;
import com.nimbusds.oauth2.sdk.device.DeviceCodeGrant;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.nimbusds.oauth2.sdk.token.TypelessToken;
import com.nimbusds.oauth2.sdk.tokenexchange.TokenExchangeGrant;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.AbstractMultivaluedMap;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import nl.topicus.keyhub.cli.rest.AbstractRestClient;
import nl.topicus.keyhub.cli.storage.StoredCredential;
import nl.topicus.keyhub.servicecontract.http.Constants;
import nl.topicus.keyhub.servicecontract.model.auth.AuthenticationAttribute;
import nl.topicus.keyhub.servicecontract.model.auth.PermissionScope;
import nl.topicus.keyhub.servicecontract.model.auth.SecurityLevel;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class AuthRestClient
extends AbstractRestClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readVersion(StoredCredential credential) {
        String string;
        Response response = null;
        try {
            Client client = this.restClientBuilder().getClient();
            response = client.target(this.resolve(credential, "info")).request(Constants.KEYHUB_JSON_TYPE).get();
            string = this.toMap(response, true).get("keyHubVersion").toString();
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
        return string;
    }

    public Map<String, Object> fetchAccessTokenUsingDeviceAuthorization(StoredCredential credential, Map<String, List<String>> parameters) {
        Map<String, Object> ret;
        DeviceAuthorizationSuccessResponse response;
        Scope scope;
        parameters.put(AuthenticationAttribute.REQUIRED_LEVEL.getName(), Collections.singletonList(SecurityLevel.HIGH.name().toLowerCase()));
        if (credential.getTargetClientId() != null) {
            parameters.put("resource", List.of(credential.getTargetResourceURI()));
            scope = new Scope(PermissionScope.PROFILE.getScope());
        } else {
            parameters.put(AuthenticationAttribute.VAULT.getName(), Collections.singletonList(AuthenticationAttribute.VaultAuthentication.ACCESS.getName()));
            scope = new Scope(PermissionScope.PROFILE.getScope(), PermissionScope.ACCESS_VAULT.getScope(), PermissionScope.PROVISIONING.getScope());
        }
        UriBuilder uriBuilder = UriBuilder.fromUri(credential.getUri()).path("login/oauth2/authorizedevice");
        DeviceAuthorizationRequest authRequest = credential.isClientSecretRequired() ? new DeviceAuthorizationRequest(uriBuilder.build(new Object[0]), new ClientSecretBasic(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret())), scope, parameters) : new DeviceAuthorizationRequest(uriBuilder.build(new Object[0]), new ClientID(credential.getClientId()), scope, parameters);
        Map<String, Object> deviceAuth = this.request(authRequest.toHTTPRequest());
        if (deviceAuth.containsKey("error")) {
            throw new IllegalStateException("Authentication failed: " + String.valueOf(deviceAuth));
        }
        try {
            response = DeviceAuthorizationSuccessResponse.parse(new JSONObject(deviceAuth));
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        this.env().err().println("Authentication is required");
        this.env().err().println();
        this.env().err().printf("%1$-60s %2$s\n", "Using a browser visit", "And enter the code");
        this.env().err().printf("%1$-60s %2$s\n", response.getVerificationURI().toString(), response.getUserCode().toString());
        this.env().err().println();
        this.env().err().println("Or directly visit");
        this.env().err().println(response.getVerificationURIComplete().toString());
        this.env().err().println();
        this.env().browse(response.getVerificationURIComplete().toString());
        long interval = response.getInterval();
        do {
            try {
                Thread.sleep(interval * 1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } while ("authorization_pending".equals((ret = this.tryFetchAccessTokenForDeviceGrant(credential, response.getDeviceCode())).get("error")));
        return ret;
    }

    private Map<String, Object> tryFetchAccessTokenForDeviceGrant(StoredCredential credential, DeviceCode deviceCode) {
        UriBuilder uriBuilder = UriBuilder.fromUri(credential.getUri()).path("login/oauth2/token");
        TokenRequest tokenRequest = credential.isClientSecretRequired() ? new TokenRequest(uriBuilder.build(new Object[0]), new ClientSecretBasic(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret())), (AuthorizationGrant)new DeviceCodeGrant(deviceCode), null) : new TokenRequest(uriBuilder.build(new Object[0]), new ClientID(credential.getClientId()), (AuthorizationGrant)new DeviceCodeGrant(deviceCode), null);
        return this.request(tokenRequest.toHTTPRequest());
    }

    public Map<String, Object> fetchAccessTokenUsingClientCredentials(StoredCredential credential) {
        if (credential.getClientSecret() == null) {
            throw new IllegalStateException("Cannot refresh access token, no secret stored/given.");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri(credential.getUri()).path("login/oauth2/token");
        TokenRequest tokenRequest = new TokenRequest(uriBuilder.build(new Object[0]), new ClientSecretBasic(new ClientID(credential.getClientId().toString()), new Secret(credential.getClientSecret())), (AuthorizationGrant)new ClientCredentialsGrant(), null, null, null, null, Collections.singletonMap(AuthenticationAttribute.VAULT.getName(), Collections.singletonList(AuthenticationAttribute.VaultAuthentication.ACCESS.getName())));
        return this.request(tokenRequest.toHTTPRequest());
    }

    public Map<String, Object> fetchAccessTokenUsingRefreshToken(StoredCredential credential) {
        if (credential.getClientSecret() == null || credential.getRefreshToken() == null) {
            throw new IllegalStateException("Cannot refresh access token, no secret stored/given.");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri(credential.getUri()).path("login/oauth2/token");
        TokenRequest tokenRequest = new TokenRequest(uriBuilder.build(new Object[0]), new ClientSecretBasic(new ClientID(credential.getClientId().toString()), new Secret(credential.getClientSecret())), (AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(credential.getRefreshToken())), null, null, null, null, Collections.singletonMap(AuthenticationAttribute.VAULT.getName(), Collections.singletonList(AuthenticationAttribute.VaultAuthentication.ACCESS.getName())));
        return this.request(tokenRequest.toHTTPRequest());
    }

    public void logout(StoredCredential credential) {
        UriBuilder builder = UriBuilder.fromUri(credential.getUri()).path("login/oauth2/revoke");
        try {
            BearerAccessToken token = BearerAccessToken.parse("Bearer " + credential.getAccessToken());
            TokenRevocationRequest revocationRequest = credential.getClientId() != null ? (credential.getClientSecret() != null ? new TokenRevocationRequest(builder.build(new Object[0]), new ClientSecretBasic(new ClientID(credential.getClientId().toString()), new Secret(credential.getClientSecret())), (Token)token) : new TokenRevocationRequest(builder.build(new Object[0]), new ClientID(credential.getClientId().toString()), (Token)token)) : new TokenRevocationRequest(builder.build(new Object[0]), new ClientID("77ef8551-b8f2-46da-9932-1241e7997b0b"), (Token)token);
            this.request(revocationRequest.toHTTPRequest());
        }
        catch (ParseException e) {
            this.env().err().println("Error while parsing accesstoken in order to logout, continuing with logout locally.");
            return;
        }
        catch (ProcessingException e) {
            this.env().err().println("Error while logging out at keyhub, continuing with logout locally.");
        }
    }

    private Map<String, Object> request(HTTPRequest request) {
        Map<String, Object> map;
        Response response = null;
        try {
            boolean hasEntity = request.getMethod().equals((Object)HTTPRequest.Method.POST) || request.getMethod().equals((Object)HTTPRequest.Method.PUT);
            ResteasyClient client = (ResteasyClient)this.restClientBuilder().getClient();
            ResteasyWebTarget target = client.target(request.getURI());
            if (!hasEntity) {
                target.queryParams(this.toMultivaluedMap(request.getQueryStringParameters()));
            }
            Invocation.Builder invocation = target.request().headers(this.toMultivaluedMap(request.getHeaderMap()));
            if (hasEntity) {
                MultivaluedHashMap<String, String> body = new MultivaluedHashMap<String, String>();
                ((AbstractMultivaluedMap)body).putAll(request.getBodyAsFormParameters());
                Form form = new Form(body);
                response = invocation.method(request.getMethod().name(), Entity.entity(form, request.getEntityContentType().toString()));
            } else {
                response = invocation.method(request.getMethod().name());
            }
            map = this.toMap(response, false);
        }
        catch (ParseException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.close(response);
                throw throwable;
            }
        }
        this.close(response);
        return map;
    }

    private <K, V1, V2 extends V1> MultivaluedMap<K, V1> toMultivaluedMap(Map<K, List<V2>> input) {
        MultivaluedHashMap ret = new MultivaluedHashMap();
        input.forEach((k, vl) -> vl.forEach(v -> ret.putSingle(k, v)));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> exchange(StoredCredential credential) {
        Response response = null;
        try {
            UriBuilder uriBuilder = UriBuilder.fromUri(credential.getUri()).path("login/oauth2/token");
            TokenRequest tokenRequest = credential.getClientSecret() != null ? new TokenRequest(uriBuilder.build(new Object[0]), new ClientSecretBasic(new ClientID(credential.getClientId().toString()), new Secret(credential.getClientSecret())), (AuthorizationGrant)new TokenExchangeGrant(new TypelessToken(credential.getAccessToken()), TokenTypeURI.ACCESS_TOKEN), null, null, List.of(URI.create(credential.getTargetResourceURI())), null, null) : new TokenRequest(uriBuilder.build(new Object[0]), new ClientID(credential.getClientId()), new TokenExchangeGrant(new TypelessToken(credential.getAccessToken()), TokenTypeURI.ACCESS_TOKEN), null, null, List.of(URI.create(credential.getTargetResourceURI())), null, null, null);
            Map<String, Object> map = this.request(tokenRequest.toHTTPRequest());
            return map;
        }
        finally {
            this.close(response);
        }
    }
}

