/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import com.google.common.base.Strings;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import nl.topicus.keyhub.cli.rest.AbstractRestClient;
import nl.topicus.keyhub.servicecontract.http.Constants;
import nl.topicus.keyhub.servicecontract.model.SegmentedLinkableWrapper;
import nl.topicus.keyhub.servicecontract.model.auth.Account;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.TokenPassword;

public class AccountRestClient
extends AbstractRestClient {
    private static final GenericType<SegmentedLinkableWrapper<Account>> WRAPPER_TYPE = new GenericType<SegmentedLinkableWrapper<Account>>(){};

    public Account me() {
        Response response = null;
        try {
            response = this.relative("account/me").get();
            Account account = this.read(response, Account.class);
            return account;
        }
        finally {
            this.close(response);
        }
    }

    public TokenPassword getTokenPassword() {
        Response response = null;
        try {
            response = this.relative("account/provisioning/tokenpwd").get();
            if (response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
                throw new IllegalStateException("Rotating password is not enabled.");
            }
            TokenPassword tokenPassword = this.read(response, TokenPassword.class);
            return tokenPassword;
        }
        finally {
            this.close(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rotateTokenPassword() {
        Response response;
        block5: {
            boolean bl;
            response = null;
            try {
                response = this.relative("account/provisioning/rotatepwd").method("POST");
                if (response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
                    throw new IllegalStateException("Rotating password is not enabled.");
                }
                Optional<Boolean> retry = this.retryWithReAuth(response, this::rotateTokenPassword);
                if (!retry.isPresent()) break block5;
                bl = retry.get();
            }
            catch (Throwable throwable) {
                this.close(response);
                throw throwable;
            }
            this.close(response);
            return bl;
        }
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw this.error(response);
        }
        boolean bl = true;
        this.close(response);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account get(UUID uuid) {
        Account account;
        Response response = null;
        try {
            response = this.absolute(this.resolve("account").queryParam("uuid", "{uuid}").resolveTemplate("uuid", uuid).build(new Object[0])).get();
            SegmentedLinkableWrapper<Account> accounts = this.read(response, WRAPPER_TYPE);
            if (accounts.getItems().isEmpty()) {
                throw new NoSuchElementException("No accounts with UUID '" + String.valueOf(uuid) + "' exists or permission denied.");
            }
            account = accounts.getFirstAs(Account.class);
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningStatus getProvisioningStatus(String filter, UUID uuid) {
        ProvisioningStatus provisioningStatus;
        Response response = null;
        try {
            UriBuilder uriBuilder = this.resolve("account/provisioning");
            if (!Strings.isNullOrEmpty(filter)) {
                uriBuilder = uriBuilder.queryParam("filter", "{filter}").resolveTemplate("filter", filter);
            }
            if (uuid != null) {
                uriBuilder = uriBuilder.queryParam("groupUuid", "{groupUuid}").resolveTemplate("groupUuid", uuid.toString());
            }
            response = this.absolute(uriBuilder.build(new Object[0])).get();
            provisioningStatus = this.read(response, ProvisioningStatus.class);
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
        return provisioningStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningStatus updateProvisioningStatus(ProvisioningStatus status, String reason) {
        ProvisioningStatus provisioningStatus;
        Response response = null;
        try {
            UriBuilder uriBuilder = this.resolve("account/provisioning");
            if (!Strings.isNullOrEmpty(reason)) {
                uriBuilder = uriBuilder.queryParam("reason", "{reason}").resolveTemplate("reason", reason);
            }
            if ((response = this.absolute(uriBuilder.build(new Object[0])).put(Entity.entity(status, Constants.KEYHUB_VERSIONED_JSON_TYPE))).getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new IllegalStateException("Server refused provisioning update with a HTTP 401. Please note that if you provision a group for the first time, you need to do so via the web console.");
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new IllegalStateException("Server gave HTTP " + response.getStatus());
            }
            provisioningStatus = this.read(response, ProvisioningStatus.class);
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        this.close(response);
        return provisioningStatus;
    }

    public List<Account> query(String name, UUID uuid, String matches, String query) {
        UriBuilder uriBuilder = this.resolve("/account");
        if (name != null) {
            uriBuilder = uriBuilder.queryParam("username", "{name}").resolveTemplate("name", name);
        }
        if (uuid != null) {
            uriBuilder = uriBuilder.queryParam("uuid", "{uuid}").resolveTemplate("uuid", uuid);
        }
        if (!Strings.isNullOrEmpty(matches)) {
            uriBuilder = uriBuilder.queryParam("usernameContains", "{matches}").resolveTemplate("matches", matches);
        }
        if (query != null) {
            uriBuilder = uriBuilder.queryParam("q", "{query}").resolveTemplate("query", query);
        }
        uriBuilder = uriBuilder.queryParam("sort", "asc-username");
        return this.readAll(uriBuilder.build(new Object[0]), WRAPPER_TYPE);
    }
}

