/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.rest;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minidev.json.JSONObject;
import nl.topicus.cobra.restcontract.http.RequestRange;
import nl.topicus.cobra.restcontract.http.ResponseRange;
import nl.topicus.cobra.restcontract.model.CobraError;
import nl.topicus.cobra.restcontract.model.ErrorReport;
import nl.topicus.cobra.restcontract.model.ILinkable;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.keyhub.cli.ServiceAccess;
import nl.topicus.keyhub.cli.storage.StoredCredential;
import nl.topicus.keyhub.servicecontract.http.Constants;
import nl.topicus.keyhub.servicecontract.model.KeyHubError;
import nl.topicus.keyhub.servicecontract.model.auth.AuthenticationAttribute;

public abstract class AbstractRestClient
implements ServiceAccess {
    private static final int QUERY_LIMIT = 1000;

    protected UriBuilder resolve(String path) {
        this.credentials().assertAuthenticatedToKeyHub();
        StoredCredential credential = this.credentials().getActiveCredential();
        return this.resolve(credential, path);
    }

    protected UriBuilder resolve(StoredCredential credential, String path) {
        return UriBuilder.fromUri(credential.getUri()).path("keyhub/rest/v1").path(path);
    }

    protected Invocation.Builder relative(String path) {
        return this.absolute(this.resolve(path).build(new Object[0]));
    }

    protected Invocation.Builder absolute(URI uri) {
        return this.restClientBuilder().getClient().target(uri).request(Constants.KEYHUB_VERSIONED_JSON_TYPE).header("Authorization", "Bearer " + this.credentials().aquireAccessToken());
    }

    protected <T> T read(Response response, GenericType<T> type) {
        this.checkResponseCode(response);
        return response.readEntity(type);
    }

    protected <T> T read(Response response, Class<T> type) {
        if (!ErrorReport.class.equals(type)) {
            this.checkResponseCode(response);
        }
        try {
            ObjectMapper mapper = this.restClientBuilder().getMapper();
            return mapper.readValue(response.readEntity(String.class), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends ILinkable> T readFirst(Response response, Class<T> type) {
        this.checkResponseCode(response);
        try {
            ObjectMapper mapper = this.restClientBuilder().getMapper();
            LinkableWrapper wrapper = (LinkableWrapper)mapper.readValue(response.readEntity(String.class), mapper.getTypeFactory().constructParametricType(LinkableWrapper.class, type));
            if (wrapper.getItems().isEmpty()) {
                throw new NoSuchElementException();
            }
            return wrapper.getFirstAs(type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends ILinkable, W extends LinkableWrapper<T>> List<T> readAll(URI uri, GenericType<W> wrapper) {
        return this.readAll(uri, wrapper, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ILinkable, W extends LinkableWrapper<T>> List<T> readAll(URI uri, GenericType<W> wrapper, boolean notFoundToEmptyList) {
        ArrayList ret = new ArrayList();
        long index = 0L;
        long total = Long.MAX_VALUE;
        while (index < total) {
            Response response;
            block5: {
                response = null;
                try {
                    response = this.absolute(uri).header("topicus-Vault-session", this.credentials().getVaultSession(true)).header("Range", new RequestRange(index, 100L)).get();
                    if (!notFoundToEmptyList || response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break block5;
                    List list = List.of();
                    this.close(response);
                    return list;
                }
                catch (Throwable throwable) {
                    this.close(response);
                    throw throwable;
                }
            }
            if (response.getStatus() != Response.Status.PARTIAL_CONTENT.getStatusCode()) {
                throw this.error(response);
            }
            ret.addAll(((LinkableWrapper)this.read(response, wrapper)).getWrapped());
            ResponseRange range = new ResponseRange(response.getHeaderString("Content-Range"));
            index = range.getEnd() + 1L;
            total = range.getTotalSize();
            this.close(response);
            if (ret.size() < 1000) continue;
            this.env().err().println("Query limit of 1000 reached");
        }
        return ret;
    }

    protected Map<String, Object> toMap(Response response, boolean checkErrors) {
        if (checkErrors) {
            this.checkResponseCode(response);
        }
        try {
            ObjectMapper mapper = this.restClientBuilder().getMapper();
            MapType mapType = mapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Object.class);
            String responseContents = response.readEntity(String.class);
            if (responseContents.trim().isEmpty()) {
                return Collections.emptyMap();
            }
            return (Map)mapper.readValue(responseContents, (JavaType)mapType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ProcessingException error(Response response) {
        String errorStr = null;
        try {
            response.bufferEntity();
            errorStr = response.readEntity(String.class);
            ErrorReport report = response.readEntity(ErrorReport.class);
            String appError = report.getApplicationError() != null ? "(" + report.getApplicationError() + ") " : "";
            String errorMessage = "Server reported " + response.getStatus() + " " + appError + response.getStatusInfo().getReasonPhrase() + ": " + report.getException() + ": " + report.getMessage();
            this.env().vlog(errorMessage);
            if (report.getStacktrace() != null && !report.getStacktrace().isEmpty()) {
                this.env().vlog(report.getStacktrace().stream().collect(Collectors.joining("\n")));
            }
            return new ProcessingException(errorMessage);
        }
        catch (Exception e) {
            return new ProcessingException("Server reported " + response.getStatus() + " " + response.getStatusInfo().getReasonPhrase() + ". Full error is " + errorStr);
        }
    }

    protected <T> Optional<T> retryWithReAuth(Response response, Supplier<T> retry) {
        if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            ErrorReport error = this.read(response, ErrorReport.class);
            if (CobraError.USERNAME_PASSWORD_TOKEN_LOGIN_REQUIRED.name().equals(error.getApplicationError()) || CobraError.USERNAME_PASSWORD_LOGIN_REQUIRED.name().equals(error.getApplicationError()) || CobraError.FEDERATED_LOGIN_REQUIRED.name().equals(error.getApplicationError()) || KeyHubError.VAULT_NOT_UNLOCKED.name().equals(error.getApplicationError())) {
                HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
                parameters.put(AuthenticationAttribute.ERROR.getName(), Collections.singletonList(error.getApplicationError()));
                parameters.put(AuthenticationAttribute.ERROR_INFO.getName(), Collections.singletonList(new JSONObject(error.getApplicationErrorParameters()).toJSONString()));
                this.credentials().aquireAccessToken(parameters);
                return Optional.of(retry.get());
            }
        }
        this.checkResponseCode(response);
        return Optional.empty();
    }

    protected <T> Entity<T> json(T linkable) {
        return Entity.entity(linkable, Constants.KEYHUB_VERSIONED_JSON_TYPE);
    }

    protected void close(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void checkResponseCode(Response response) {
        if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
            throw new IllegalArgumentException("Version mismatch, check if your CLI version matches that of Topicus KeyHub.");
        }
        if (Response.Status.Family.SERVER_ERROR.equals((Object)response.getStatusInfo().getFamily()) || Response.Status.Family.CLIENT_ERROR.equals((Object)response.getStatusInfo().getFamily())) {
            throw this.error(response);
        }
    }
}

