/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.query;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.util.List;
import nl.topicus.keyhub.cli.print.GroupPrinter;
import nl.topicus.keyhub.cli.query.AbstractQueryCommand;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.servicecontract.model.group.Group;

@Command(name="groups", description="Query for groups.")
public class QueryGroupsCommand
extends AbstractQueryCommand {
    @Option(name={"--own"}, description="Only query for the user's own groups.")
    @SilentOnce
    private boolean own = false;

    @Override
    protected void doRun() {
        Long accountId = null;
        if (this.own) {
            this.credentials().assertUserAuthenticatedToKeyHub();
            accountId = this.credentials().getActiveCredential().getAuthPartyId();
        }
        List<Group> groups = this.groupClient().query(this.name, this.uuid, this.matches, this.query, accountId);
        this.print(groups, new GroupPrinter());
    }
}

