/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.provisioning;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import nl.topicus.keyhub.cli.provisioning.AbstractDoProvisioningCommand;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningStatus;

@Command(name="deactivate", description="Deactivates a provisioning group.")
public class DeactivateProvisioningCommand
extends AbstractDoProvisioningCommand {
    @Option(name={"--group"}, description="The group to deactivate (UUID).")
    @RequireOnlyOne(tag="group(s) to deactivate")
    @ExactLength(length=36)
    @SilentOnce
    private UUID groupUuid;
    @Option(name={"--all"}, description="Deactivate all active groups.")
    @RequireOnlyOne(tag="group(s) to deactivate")
    @SilentOnce
    private boolean deactivateAll;

    @Override
    protected ProvisioningStatus runProvisioningCommand() {
        ProvisioningStatus provisioningStatus = this.accountClient().getProvisioningStatus(null, this.groupUuid);
        if (this.groupUuid != null && provisioningStatus.getGroups().isEmpty()) {
            throw new IllegalArgumentException("Group with UUID " + String.valueOf(this.groupUuid) + " does not exist");
        }
        for (GroupProvisioningStatus groupProvisioningStatus : provisioningStatus.getGroups()) {
            if (groupProvisioningStatus.getProvisioningEndTime().isBefore(Instant.now())) continue;
            groupProvisioningStatus.setProvisioningEndTime(Instant.now().minus(10L, ChronoUnit.MINUTES));
        }
        return this.accountClient().updateProvisioningStatus(provisioningStatus, null);
    }

    @Override
    protected boolean isDeactivation() {
        return true;
    }
}

