/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.provisioning;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.MaxLength;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.annotations.restrictions.ranges.IntegerRange;
import com.google.common.base.Strings;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import nl.topicus.keyhub.cli.provisioning.AbstractDoProvisioningCommand;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.request.AuthorizingGroupType;

@Command(name="activate", description="Activates a provisioning group.")
public class ActivateProvisioningCommand
extends AbstractDoProvisioningCommand {
    @Option(name={"--group"}, description="The group to activate (UUID).")
    @Required
    @ExactLength(length=36)
    @SilentOnce
    private UUID groupUuid;
    @Option(name={"--minutes"}, description="The length of time the group should be activated (in minutes). The default is 60 minutes (1 hour).")
    @IntegerRange(min=1, max=720)
    @SilentOnce
    private int durationInMinutes = 60;
    @Option(name={"--reason"}, description="The reason to use for activation.")
    @MaxLength(length=255)
    @SilentOnce
    private String reason;

    @Override
    public ProvisioningStatus runProvisioningCommand() {
        Instant permissionEnd;
        ProvisioningStatus provisioningStatus = this.accountClient().getProvisioningStatus(null, this.groupUuid);
        GroupProvisioningStatus groupProvisioningStatus = provisioningStatus.getGroups().stream().filter(g -> g.getGroup().getUuid().equals(this.groupUuid.toString())).findFirst().orElseThrow(() -> new IllegalArgumentException("Group with UUID " + String.valueOf(this.groupUuid) + " does not exist"));
        Group group = groupProvisioningStatus.getGroup();
        if (group.isRecordTrail() && Strings.isNullOrEmpty(this.reason)) {
            throw new IllegalArgumentException("Reason is required for activation of the group with UUID " + String.valueOf(this.groupUuid));
        }
        if (group.getAuthorizingGroupTypes().contains((Object)AuthorizingGroupType.PROVISIONING) && ((permissionEnd = groupProvisioningStatus.getProvisioningPermissionEndTime()) == null || permissionEnd.isBefore(Instant.now()))) {
            throw new IllegalArgumentException("Permission is required for activation of the group with UUID " + String.valueOf(this.groupUuid));
        }
        groupProvisioningStatus.setProvisioningEndTime(Instant.now().plus((long)this.durationInMinutes, ChronoUnit.MINUTES));
        return this.accountClient().updateProvisioningStatus(provisioningStatus, this.reason);
    }

    @Override
    protected boolean isDeactivation() {
        return false;
    }
}

