/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.provisioning;

import nl.topicus.keyhub.cli.AbstractKeyHubOutputCommand;
import nl.topicus.keyhub.servicecontract.model.provisioning.AccountProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.AccountProvisioningStatusReport;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupOnSystemPrimer;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningStatus;

abstract class AbstractDoProvisioningCommand
extends AbstractKeyHubOutputCommand {
    AbstractDoProvisioningCommand() {
    }

    @Override
    protected void doRun() {
        this.credentials().assertUserAuthenticatedToKeyHub();
        ProvisioningStatus statusReport = this.runProvisioningCommand();
        String errors = this.extractErrorsFromProvisioningStatus(statusReport);
        if (errors != null) {
            throw new IllegalStateException(errors);
        }
    }

    protected abstract ProvisioningStatus runProvisioningCommand();

    protected abstract boolean isDeactivation();

    private String extractErrorsFromProvisioningStatus(ProvisioningStatus statusReport) {
        StringBuilder errors = new StringBuilder();
        for (GroupProvisioningStatus curGroup : statusReport.getGroups()) {
            AccountProvisioningStatusReport accountStatusReport = curGroup.getStatusReport();
            for (AccountProvisioningStatus curStatus : accountStatusReport.getAllErrorStatus()) {
                errors.append(String.format("\nThe group %s (%s) on %s could not be %s.", curStatus.getProvisioningGroup().getGroup().getName(), this.displayName(curStatus.getProvisioningGroup().getGroupOnSystem()), curStatus.getProvisioningGroup().getGroupOnSystem().getSystem().getName(), this.isDeactivation() ? "deactivated" : "activated"));
            }
        }
        if (!errors.isEmpty()) {
            return String.format("Could not %s all groups.%s", this.isDeactivation() ? "deactivate" : "activate", errors.toString());
        }
        return null;
    }

    protected String displayName(GroupOnSystemPrimer gos) {
        return gos.getDisplayName() == null ? gos.getShortNameInSystem() : gos.getDisplayName();
    }
}

