/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultSecretType;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;
import org.apache.commons.lang3.tuple.Pair;

public class VaultRecordSecretPrinter
implements CLIObjectPrinter<VaultRecord, Pair<VaultSecretType, String>> {
    @Override
    public List<Pair<VaultSecretType, String>> toElements(VaultRecord value) {
        return Stream.of(VaultSecretType.values()).filter(value.getTypes()::contains).map(t -> Pair.of(t, value.getAdditionalObjects(VaultRecordResource.SECRETS).get((VaultSecretType)((Object)t)))).collect(Collectors.toList());
    }

    @Override
    public List<String> headers(VaultRecord value) {
        return List.of("type", "value");
    }

    @Override
    public List<String> values(Pair<VaultSecretType, String> element) {
        String label = switch (element.getKey()) {
            case VaultSecretType.COMMENT -> "Comment";
            case VaultSecretType.FILE -> "File";
            case VaultSecretType.PASSWORD -> "Password";
            case VaultSecretType.TOTP -> "TOTP";
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)element.getKey()));
        };
        return List.of(label, element.getRight());
    }

    @Override
    public String sectionHeader(Pair<VaultSecretType, String> element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<OutputLine> sectionDetails(Pair<VaultSecretType, String> element) {
        throw new UnsupportedOperationException();
    }
}

