/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;
import nl.topicus.keyhub.servicecontract.model.auth.AccountPrimer;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2Client;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;
import nl.topicus.keyhub.servicecontract.model.vault.PasswordMetadata;
import nl.topicus.keyhub.servicecontract.model.vault.VaultHolder;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordSecrets;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordShare;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordShareSummary;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordQueryResource;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

public class VaultRecordPrinter
implements CLIObjectPrinter<List<VaultRecord>, VaultRecord> {
    private boolean showVaultColumns;

    public VaultRecordPrinter(boolean showVaultColumns) {
        this.showVaultColumns = showVaultColumns;
    }

    @Override
    public List<VaultRecord> toElements(List<VaultRecord> value) {
        return value;
    }

    @Override
    public List<String> headers(List<VaultRecord> value) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.showVaultColumns) {
            ret.addAll(List.of("vault", "vault name"));
        }
        ret.addAll(List.of("record", "name", "url", "username", "secrets"));
        return ret;
    }

    @Override
    public List<String> values(VaultRecord element) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.showVaultColumns) {
            VaultHolder vaultHolder = element.getAdditionalObjects(VaultRecordResource.VAULTHOLDER);
            if (vaultHolder instanceof GroupPrimer) {
                GroupPrimer group = (GroupPrimer)vaultHolder;
                ret.add(group.getUuid());
                ret.add(group.getName());
            } else {
                if (vaultHolder instanceof AccountPrimer) {
                    AccountPrimer account = (AccountPrimer)vaultHolder;
                    ret.add(account.getUuid());
                } else if (vaultHolder instanceof OAuth2Client) {
                    OAuth2Client client = (OAuth2Client)vaultHolder;
                    ret.add(client.getUuid());
                } else {
                    ret.add("-");
                }
                ret.add("personal vault");
            }
        }
        char[] types = new char[]{' ', ' ', ' ', ' '};
        element.getTypes().forEach(t -> {
            types[t.ordinal()] = t.name().charAt(0);
        });
        ret.addAll(Arrays.asList(element.getUuid(), element.getName(), element.getUrl(), element.getUsername(), new String(types)));
        return ret;
    }

    @Override
    public String sectionHeader(VaultRecord element) {
        return element.getName();
    }

    @Override
    public List<OutputLine> sectionDetails(VaultRecord element) {
        PasswordMetadata metadata = element.getAdditionalObjects(VaultRecordQueryResource.PASSWORD_METADATA);
        VaultRecordShareSummary share = element.getAdditionalObjects(VaultRecordQueryResource.SHARE_SUMMARY);
        VaultRecordSecrets secrets = element.getAdditionalObjects(VaultRecordResource.SECRETS);
        return List.of(new OutputLine("UUID", element.getUuid()), new OutputLine("Name", element.getName()), new OutputLine("Vault", element.getAdditionalObjects(VaultRecordQueryResource.VAULTHOLDER).toOmschrijving()), new OutputLine("Password", secrets == null ? null : secrets.getPassword()), new OutputLine("File", secrets == null ? null : secrets.getFile()), new OutputLine("TOTP", secrets == null ? null : secrets.getTotp()), new OutputLine("Comment", secrets == null ? null : secrets.getComment()), new OutputLine("Color", (Object)element.getColor()), new OutputLine("url", element.getUrl()), new OutputLine("Username", element.getUsername()), new OutputLine("Filename", element.getFilename()), new OutputLine("End date", element.getEndDate()), new OutputLine("Warning period", (Object)element.getWarningPeriod()), new OutputLine("Password strength", metadata == null ? null : Integer.valueOf(metadata.getStrength())), new OutputLine("Password reused", metadata == null ? null : Boolean.valueOf(metadata.isDuplicate())), new OutputLine("Shared from", share.getParent() == null ? null : share.getParent().getName()), new OutputLine("Shared with", share.getChildren().isEmpty() ? null : share.getChildren().stream().map(VaultRecordShare::getName).collect(Collectors.joining(", "))), new OutputLine("Share end time", CLIObjectPrinter.format(element.getShareEndTime())), new OutputLine("Derived", element.isDerived()));
    }
}

