/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import java.util.List;
import java.util.function.Function;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;

public class SimpleValuePrinter<T>
implements CLIObjectPrinter<T, T> {
    private Function<T, String> printer;

    public static <T> SimpleValuePrinter<T> of(Function<T, String> printer) {
        return new SimpleValuePrinter<T>(printer);
    }

    private SimpleValuePrinter(Function<T, String> printer) {
        this.printer = printer;
    }

    @Override
    public boolean printHeaders(String outputFormat) {
        return "csv".equals(outputFormat);
    }

    @Override
    public List<T> toElements(T value) {
        return List.of(value);
    }

    @Override
    public List<String> headers(T value) {
        return List.of("value");
    }

    @Override
    public List<String> values(T element) {
        return List.of(this.printer.apply(element));
    }

    @Override
    public String sectionHeader(T element) {
        return null;
    }

    @Override
    public List<OutputLine> sectionDetails(T element) {
        return List.of(new OutputLine("value", this.printer.apply(element)));
    }
}

