/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import java.time.Instant;
import java.util.List;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.request.AuthorizingGroupType;

public class ProvisioningStatusPrinter
implements CLIObjectPrinter<ProvisioningStatus, GroupProvisioningStatus> {
    @Override
    public List<GroupProvisioningStatus> toElements(ProvisioningStatus value) {
        return value.getGroups();
    }

    @Override
    public List<String> headers(ProvisioningStatus value) {
        return List.of("uuid", "name", "status", "reason", "authorization", "folder");
    }

    @Override
    public List<String> values(GroupProvisioningStatus element) {
        Group group = element.getGroup();
        String status = this.getStatus(element);
        String reason = group.isRecordTrail() ? "required" : "not required";
        String authorization = this.getAuthorizationStatus(element);
        String folder = element.getFolder() == null ? "" : element.getFolder().getName();
        return List.of(group.getUuid(), group.getName(), status, reason, authorization, folder);
    }

    @Override
    public String sectionHeader(GroupProvisioningStatus element) {
        return element.getGroup().getName();
    }

    @Override
    public List<OutputLine> sectionDetails(GroupProvisioningStatus element) {
        return List.of(new OutputLine("UUID", element.getGroup().getUuid()), new OutputLine("Name", element.getGroup().getName()), new OutputLine("Folder", element.getFolder() == null ? null : element.getFolder().getName()), new OutputLine("Visible on dashboard", element.isVisibleOnDashboard()), new OutputLine("Status", this.getStatus(element)), new OutputLine("Authorization status", this.getAuthorizationStatus(element)), new OutputLine("Record trail", element.getGroup().isRecordTrail()), new OutputLine("Provisioning end time", CLIObjectPrinter.formatFuture(element.getProvisioningEndTime())), new OutputLine("Authorization end time", this.hasProvisioningAuth(element) ? CLIObjectPrinter.formatFuture(element.getProvisioningPermissionEndTime()) : null));
    }

    private boolean hasProvisioningAuth(GroupProvisioningStatus element) {
        return element.getGroup().getAuthorizingGroupTypes().contains((Object)AuthorizingGroupType.PROVISIONING);
    }

    private String getStatus(GroupProvisioningStatus element) {
        return element.getProvisioningEndTime().isBefore(Instant.now()) ? "inactive" : "active until " + CLIObjectPrinter.format(element.getProvisioningEndTime());
    }

    private String getAuthorizationStatus(GroupProvisioningStatus element) {
        if (!this.hasProvisioningAuth(element)) {
            return "not required";
        }
        if (element.getProvisioningEndTime() != null && element.getProvisioningPermissionEndTime().isAfter(Instant.now())) {
            return "granted until " + CLIObjectPrinter.format(element.getProvisioningPermissionEndTime());
        }
        return "required";
    }
}

