/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import java.util.List;
import java.util.stream.Collectors;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;

public class GroupPrinter
implements CLIObjectPrinter<List<Group>, Group> {
    @Override
    public List<Group> toElements(List<Group> value) {
        return value;
    }

    @Override
    public List<String> headers(List<Group> value) {
        return List.of("uuid", "name");
    }

    @Override
    public List<String> values(Group element) {
        return List.of(element.getUuid(), element.getName());
    }

    @Override
    public String sectionHeader(Group element) {
        return element.getName();
    }

    @Override
    public List<OutputLine> sectionDetails(Group element) {
        return List.of(new OutputLine("UUID", element.getUuid()), new OutputLine("Name", element.getName()), new OutputLine("Description", element.getDescription()), new OutputLine("Organizational unit", element.getOrganizationalUnit().getName()), new OutputLine("Classification", element.getClassification().getName()), new OutputLine("Application administration", element.isApplicationAdministration()), new OutputLine("Access profile administration", element.isProfileAdministration()), new OutputLine("KeyHub administrators", element.isAdmin()), new OutputLine("Authorizing group for provisioning", this.toName(element.getAuthorizingGroupProvisioning())), new OutputLine("Authorizing group for membership", this.toName(element.getAuthorizingGroupMembership())), new OutputLine("Authorizing group for delegation", this.toName(element.getAuthorizingGroupDelegation())), new OutputLine("Authorizing group for auditing", this.toName(element.getAuthorizingGroupAuditing())), new OutputLine("Nested under", this.toName(element.getNestedUnder())), new OutputLine("Audit months", element.getAuditConfig().getMonths().stream().map(Enum::toString).collect(Collectors.joining(", "))), new OutputLine("Private", element.isPrivateGroup()), new OutputLine("Hide audit trail", element.isHideAuditTrail()), new OutputLine("Vault requires activation", element.isVaultRequiresActivation()), new OutputLine("Rotating password required", element.isRotatingPasswordRequired()), new OutputLine("Extended access", (Object)element.getExtendedAccess()), new OutputLine("Record trail", element.isRecordTrail()), new OutputLine("Vault recovery", (Object)element.getVaultRecovery()));
    }

    private String toName(GroupPrimer group) {
        return group == null ? null : group.getName();
    }
}

