/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import nl.topicus.keyhub.cli.print.OutputLine;

public interface CLIObjectPrinter<T, E> {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm");

    default public String preface(T value) {
        return null;
    }

    default public boolean printHeaders(String outputFormat) {
        return true;
    }

    public List<E> toElements(T var1);

    public List<String> headers(T var1);

    public List<String> values(E var1);

    public String sectionHeader(E var1);

    public List<OutputLine> sectionDetails(E var1);

    public static String format(Instant instant) {
        if (instant == null) {
            return null;
        }
        return DATE_FORMATTER.format(instant.atZone(ZoneId.systemDefault()));
    }

    public static String formatFuture(Instant instant) {
        if (instant == null) {
            return null;
        }
        if (instant.isBefore(Instant.now())) {
            return null;
        }
        return DATE_FORMATTER.format(instant.atZone(ZoneId.systemDefault()));
    }
}

