/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.print;

import com.google.common.base.Strings;
import java.util.List;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;
import nl.topicus.keyhub.servicecontract.model.auth.Account;

public class AccountPrinter
implements CLIObjectPrinter<List<Account>, Account> {
    @Override
    public List<Account> toElements(List<Account> value) {
        return value;
    }

    @Override
    public List<String> headers(List<Account> value) {
        return List.of("uuid", "username", "display name");
    }

    @Override
    public List<String> values(Account element) {
        return List.of(element.getUuid(), element.getUsername(), Strings.nullToEmpty(element.getDisplayName()));
    }

    @Override
    public String sectionHeader(Account element) {
        return element.toOmschrijving();
    }

    @Override
    public List<OutputLine> sectionDetails(Account element) {
        return List.of(new OutputLine("UUID", element.getUuid()), new OutputLine("Username", element.getUsername()), new OutputLine("Display name", element.getDirectoryName()), new OutputLine("Email", element.getEmail()), new OutputLine("Validity", element.getValidity().name()), new OutputLine("Directory name", element.getDirectoryName()), new OutputLine("ID in directory", element.getIdInDirectory()), new OutputLine("License role", (Object)element.getLicenseRole()));
    }
}

