/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli.auth;

import com.google.common.base.Objects;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import nl.topicus.keyhub.cli.ServiceAccess;
import nl.topicus.keyhub.cli.storage.StoredCredential;
import nl.topicus.keyhub.cli.storage.StoredCredentials;
import nl.topicus.keyhub.servicecontract.model.auth.Account;
import nl.topicus.keyhub.servicecontract.model.auth.AuthenticationAttribute;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2Client;

public class CredentialServiceImpl
implements ServiceAccess {
    private StoredCredentials storedCredentials;
    private StoredCredential activeCredential;

    public void init() {
        this.storedCredentials = this.storage().readCredentials();
        if (this.storedCredentials != null) {
            this.activeCredential = this.storedCredentials.getCredentials().get(this.storedCredentials.getLastActive());
        } else {
            this.storedCredentials = new StoredCredentials();
        }
    }

    public void terminate() {
        if (this.storedCredentials == null) {
            this.storage().wipe();
            this.activeCredential = null;
        } else {
            if (this.activeCredential != null) {
                if (!this.activeCredential.isStoreSecret()) {
                    this.activeCredential.setClientSecret(null);
                }
                this.storedCredentials.setLastActive(this.activeCredential.getIndex());
                this.storedCredentials.getCredentials().put(this.activeCredential.getIndex(), this.activeCredential);
                this.activeCredential = null;
            }
            this.storage().writeCredentials(this.storedCredentials);
            this.storedCredentials = null;
        }
    }

    public boolean isAuthenticated() {
        return this.activeCredential != null && this.activeCredential.getUri() != null;
    }

    public StoredCredential getActiveCredential() {
        return this.activeCredential;
    }

    public void clearTokens() {
        if (this.activeCredential != null) {
            this.activeCredential.setAccessToken(null);
            this.activeCredential.setRefreshToken(null);
        }
    }

    public void assertAuthenticatedToKeyHub() {
        if (!this.isAuthenticated()) {
            throw new IllegalStateException("Client is not connected, login first");
        }
        if (this.getActiveCredential().getTargetClientId() != null) {
            throw new IllegalStateException("Credentials with a target client cannot be used to communicate with Topicus KeyHub itself.");
        }
    }

    public void assertUserAuthenticatedToKeyHub() {
        this.assertAuthenticatedToKeyHub();
        if (this.activeCredential.isClientCredentialsGrant()) {
            throw new IllegalStateException("The active session is not authenticated as a user.");
        }
    }

    private String readSecret(String clientSecret) {
        if (!"-".equals(clientSecret)) {
            return clientSecret;
        }
        if (System.console() != null) {
            return new String(System.console().readPassword("Secret: ", new Object[0]));
        }
        this.env().out().print("Secret: ");
        try (Scanner in = new Scanner(this.env().in());){
            String string = in.nextLine();
            return string;
        }
    }

    public void login(URI uri, String clientId, String clientSecret, Boolean storeSecret, Boolean clientAuthentication, String targetClientId) {
        if (this.activeCredential == null && uri == null) {
            throw new IllegalStateException("URI is required to login.");
        }
        if (targetClientId != null && Boolean.TRUE.equals(clientAuthentication)) {
            throw new IllegalStateException("Client authentication cannot be combined with a target client.");
        }
        this.initActiveCredential(uri, clientId, targetClientId, clientAuthentication);
        if (this.activeCredential.isClientSecretRequired()) {
            if (clientSecret != null) {
                this.activeCredential.setClientSecret(this.readSecret(clientSecret));
            }
            if (storeSecret != null) {
                this.activeCredential.setStoreSecret(storeSecret);
            }
        }
        this.aquireAccessToken();
    }

    private void initActiveCredential(URI uri, String clientId, String targetClientId, Boolean clientAuthentication) {
        StoredCredential oldActiveCredential = this.activeCredential;
        if (targetClientId != null) {
            if (this.activeCredential == null || !targetClientId.equals(this.activeCredential.getTargetClientId())) {
                this.activeCredential = this.storedCredentials.getCredentials().values().stream().filter(c -> targetClientId.equals(this.activeCredential.getTargetClientId())).findFirst().orElse(null);
            }
        } else if (this.activeCredential != null && uri != null || clientId != null) {
            this.activeCredential = null;
        }
        if (this.activeCredential == null) {
            String uriStr = uri == null ? oldActiveCredential.getUri() : uri.toASCIIString();
            String clientIdNotNull = clientId == null ? "77ef8551-b8f2-46da-9932-1241e7997b0b" : clientId;
            boolean clientAuthenticationBool = Boolean.TRUE.equals(clientAuthentication);
            this.activeCredential = this.storedCredentials.getCredentials().values().stream().filter(c -> c.getUri().equals(uriStr) && c.getClientId().equals(clientIdNotNull) && Objects.equal(c.getTargetClientId(), targetClientId) && c.isClientCredentialsGrant() == clientAuthenticationBool).findFirst().orElseGet(StoredCredential::new);
            this.activeCredential.setUri(uriStr);
            this.activeCredential.setClientId(clientIdNotNull);
            this.activeCredential.setTargetClientId(targetClientId);
            this.activeCredential.setClientCredentialsGrant(clientAuthenticationBool);
            if (this.activeCredential.getIndex() == 0) {
                this.activeCredential.setIndex(this.storedCredentials.getCredentials().keySet().stream().mapToInt(i -> i).max().orElse(0) + 1);
            }
        }
    }

    public String aquireAccessToken() {
        return this.aquireAccessToken(new HashMap<String, List<String>>());
    }

    public String aquireAccessToken(Map<String, List<String>> parameters) {
        if (this.activeCredential.getAccessToken() == null || this.activeCredential.getAccessTokenExpiresAt().isBefore(Instant.now()) || !parameters.isEmpty()) {
            this.env().vlog("Need to fetch new access token");
            Map<String, Object> token = null;
            if (this.activeCredential.isClientCredentialsGrant()) {
                this.env().vlog("Fetching access token using client credentials grant");
                token = this.authClient().fetchAccessTokenUsingClientCredentials(this.activeCredential);
            } else {
                if (this.activeCredential.getRefreshToken() != null) {
                    this.env().vlog("Fetching access token using refresh token");
                    token = this.authClient().fetchAccessTokenUsingRefreshToken(this.activeCredential);
                    if (token.containsKey("error")) {
                        this.env().vlog("Token refresh failed: " + String.valueOf(token));
                    }
                }
                if (token == null || token.containsKey("error")) {
                    this.env().vlog("Fetching access token using device authorization grant");
                    token = this.authClient().fetchAccessTokenUsingDeviceAuthorization(this.activeCredential, parameters);
                }
            }
            if (token.containsKey("error")) {
                throw new IllegalStateException("Authentication failed: " + String.valueOf(token));
            }
            this.activeCredential.setAccessToken(token.get("access_token").toString());
            if (token.containsKey(AuthenticationAttribute.VAULT_SESSION.getName())) {
                this.activeCredential.setVaultSession(token.get(AuthenticationAttribute.VAULT_SESSION.getName()).toString());
            }
            this.activeCredential.setAccessTokenExpiresAt(Instant.now().plus(((Number)token.get("expires_in")).longValue(), ChronoUnit.SECONDS));
            this.activeCredential.setRefreshToken(token.containsKey("refresh_token") ? token.get("refresh_token").toString() : null);
            if (this.activeCredential.isClientCredentialsGrant()) {
                OAuth2Client client = this.clientClient().me();
                this.activeCredential.setUsername(client.getName());
                this.activeCredential.setAuthPartyUri(client.self().getHref().toASCIIString());
                this.activeCredential.setAuthPartyId(client.self().getId());
            } else if (this.activeCredential.getTargetClientId() == null) {
                Account account = this.accountClient().me();
                this.activeCredential.setUsername(account.getUsername());
                this.activeCredential.setAuthPartyUri(account.self().getHref().toASCIIString());
                this.activeCredential.setAuthPartyId(account.self().getId());
            }
        }
        return this.activeCredential.getAccessToken();
    }

    public void unlockVault(String clientSecret) {
        if (this.activeCredential.isClientSecretRequired()) {
            if (clientSecret != null) {
                this.activeCredential.setClientSecret(this.readSecret(clientSecret));
            }
            if (this.activeCredential.getClientSecret() == null) {
                throw new IllegalStateException("Cannot unlock vault, no secret stored/given.");
            }
        }
        this.activeCredential.setAccessToken(null);
        this.aquireAccessToken();
    }

    public void lockVault() {
        this.activeCredential.setVaultSession(null);
    }

    public void logout(Integer index) {
        for (StoredCredential credential : this.storedCredentials.getCredentials().values()) {
            if (index != null && credential.getIndex() != index.intValue() || credential.getAccessToken() == null) continue;
            this.authClient().logout(credential);
        }
        if (index == null) {
            this.storedCredentials = null;
        } else {
            if (index.equals(this.storedCredentials.getLastActive())) {
                this.storedCredentials.setLastActive(null);
                this.activeCredential = null;
            }
            this.storedCredentials.getCredentials().remove(index);
        }
    }

    public String getVaultSession(boolean autoUnlock) {
        if (autoUnlock && (this.activeCredential.getAccessTokenExpiresAt() == null || this.activeCredential.getAccessTokenExpiresAt().isBefore(Instant.now()))) {
            if (this.activeCredential.getClientSecret() == null) {
                this.lockVault();
            } else {
                this.unlockVault(null);
            }
        }
        return this.activeCredential.getVaultSession();
    }

    public List<StoredCredential> getAllCredentials() {
        return this.storedCredentials.getCredentials().values().stream().sorted(Comparator.comparing(StoredCredential::getIndex)).toList();
    }

    public void switchTo(int index) {
        if (!this.storedCredentials.getCredentials().containsKey(index)) {
            throw new IllegalArgumentException("Session " + index + " does not exist.");
        }
        this.activeCredential = this.storedCredentials.getCredentials().get(index);
    }
}

