/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import com.github.rvesse.airline.annotations.Command;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import nl.topicus.keyhub.cli.AbstractKeyHubCommand;
import nl.topicus.keyhub.cli.KeyHubCLI;
import nl.topicus.keyhub.cli.storage.StoredCredential;

@Command(name="version", description="Displays the version of the Topicus KeyHub CLI.")
public class VersionCommand
extends AbstractKeyHubCommand {
    @Override
    protected void doRun() {
        String value;
        Attributes.Name property;
        Attributes attrs;
        Manifest mf = null;
        try {
            Enumeration<URL> resources = VersionCommand.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (mf == null && resources.hasMoreElements()) {
                URL curManifest = resources.nextElement();
                InputStream is = curManifest.openStream();
                try {
                    if (is == null) continue;
                    Manifest curMf = new Manifest();
                    curMf.read(is);
                    if (!KeyHubCLI.class.getName().equals(curMf.getMainAttributes().get(new Attributes.Name("Main-Class")))) continue;
                    mf = curMf;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.env().out().print("CLI version: ");
        String cliVersion = "Local build";
        if (mf != null && (attrs = mf.getMainAttributes()).containsKey(property = new Attributes.Name("Implementation-Build")) && (value = attrs.getValue(property)) != null && !value.trim().isEmpty() && !value.trim().equals("null")) {
            cliVersion = value.trim();
        }
        this.env().out().println(cliVersion);
        HashSet<String> uris = new HashSet<String>();
        for (StoredCredential credential : this.credentials().getAllCredentials()) {
            if (!uris.add(credential.getUri())) continue;
            this.env().out().println("Server URI: " + credential.getUri());
            this.env().out().print("Server version: ");
            String version = this.authClient().readVersion(credential);
            this.env().out().println(version);
        }
    }
}

