/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import com.github.rvesse.airline.annotations.Command;
import java.time.Instant;
import nl.topicus.keyhub.cli.AbstractKeyHubCommand;
import nl.topicus.keyhub.cli.storage.StoredCredential;

@Command(name="status", description="Shows the status of the current connection and authentication.")
public class StatusCommand
extends AbstractKeyHubCommand {
    @Override
    protected void doRun() {
        if (this.credentials().getAllCredentials().isEmpty()) {
            this.env().out().println("Status: disconnected");
        } else {
            boolean first = true;
            for (StoredCredential credential : this.credentials().getAllCredentials()) {
                if (!first) {
                    this.env().out().println();
                }
                first = false;
                boolean active = credential.equals(this.credentials().getActiveCredential());
                this.env().out().println("Session #" + credential.getIndex() + (active ? " (active)" : ""));
                this.env().out().println("Status: connected to " + credential.getUri());
                if (credential.isClientCredentialsGrant()) {
                    this.env().out().println("  Type: client credentials grant");
                } else if (credential.getTargetClientId() != null) {
                    if (credential.getClientId().equals("77ef8551-b8f2-46da-9932-1241e7997b0b")) {
                        this.env().out().println("  Type: user authenticated on target clien, default CLI");
                    } else {
                        this.env().out().println("  Type: user authenticated on target client, custom CLI client");
                    }
                } else if (credential.getClientId().equals("77ef8551-b8f2-46da-9932-1241e7997b0b")) {
                    this.env().out().println("  Type: user authenticated on default CLI");
                } else {
                    this.env().out().println("  Type: user authenticated on custom CLI client");
                }
                this.env().out().println("  Client ID: " + credential.getClientId());
                if (credential.isClientSecretRequired()) {
                    this.env().out().println("  Client Secret: " + (credential.getClientSecret() == null ? "not stored" : "stored"));
                }
                if (credential.getTargetClientId() != null) {
                    this.env().out().println("  Authenticated for: " + credential.getTargetClientId());
                    this.env().out().println("  Access token: " + this.getAccessTokenStatus(credential));
                    continue;
                }
                if (!credential.isClientCredentialsGrant()) {
                    String username = credential.getUsername();
                    this.env().out().println("  User logged in: " + (username == null ? "<unknown>" : username));
                }
                this.env().out().println("  Access token: " + this.getAccessTokenStatus(credential));
                this.env().out().println("  Vault: " + this.getVaultStatus(credential));
            }
        }
    }

    private String getAccessTokenStatus(StoredCredential credential) {
        if (credential.getAccessToken() == null) {
            return "not available";
        }
        if (credential.getAccessTokenExpiresAt().isBefore(Instant.now())) {
            return "expired";
        }
        return "valid until " + credential.getAccessTokenExpiresAt().toString();
    }

    private String getVaultStatus(StoredCredential credential) {
        if (credential.getClientSecret() == null) {
            if (credential.getVaultSession() == null) {
                return "not available";
            }
            if (credential.getAccessTokenExpiresAt().isBefore(Instant.now())) {
                return "expired";
            }
            return "valid until " + credential.getAccessTokenExpiresAt().toString();
        }
        if (credential.getVaultSession() == null || credential.getAccessTokenExpiresAt().isBefore(Instant.now())) {
            return "unlocked on demand";
        }
        return "valid until " + credential.getAccessTokenExpiresAt().toString() + ", extended on demand";
    }
}

