/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import nl.topicus.keyhub.cli.AbstractKeyHubCommand;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;

@Command(name="login", description="Connect to a KeyHub server either as a user or as a client.")
public class LoginCommand
extends AbstractKeyHubCommand {
    @Option(name={"--uri"}, description="The root URI of the KeyHub instance including protocol (i.e. https://keyhub.mycompany.com).")
    @SilentOnce
    private URI uri;
    @Option(name={"--client-id"}, description="The client identifier as issued by KeyHub. When the client-id and secret are ommitted, the internal KeyHub Command Line Interface application is used.")
    @SilentOnce
    private String clientId;
    @Option(name={"--client-secret"}, description="The client secret as issued by KeyHub, use '-' for a prompt.")
    @SilentOnce
    private String clientSecret;
    @Option(name={"--store-secret"}, description="Store the client-secret on disk for subsequent calls.")
    @SilentOnce
    private Boolean storeSecret;
    @Option(name={"--client-credentials-grant"}, description="Authenticate as a client, rather than as a user.")
    @SilentOnce
    private Boolean clientAuthentication;
    @Option(name={"--target-client-id"}, description="Produce a login token or assertion for the specified client identifier.")
    @SilentOnce
    private String targetClientId;

    @Override
    protected void doRun() {
        if (this.uri != null && !this.env().isTestcase() && !"https".equals(this.uri.getScheme())) {
            throw new IllegalArgumentException("Only https URIs are allowed, not " + String.valueOf(this.uri));
        }
        this.credentials().login(this.uri, this.clientId, this.clientSecret, this.storeSecret, this.clientAuthentication, this.targetClientId);
        if (this.targetClientId != null) {
            Map<String, Object> exchangedToken = this.authClient().exchange(this.credentials().getActiveCredential());
            if (exchangedToken.containsKey("error") && this.credentials().getActiveCredential() != null && this.credentials().getActiveCredential().getAccessToken() != null) {
                this.credentials().clearTokens();
                this.credentials().login(this.uri, this.clientId, this.clientSecret, this.storeSecret, this.clientAuthentication, this.targetClientId);
                exchangedToken = this.authClient().exchange(this.credentials().getActiveCredential());
            }
            if (exchangedToken.containsKey("error")) {
                throw new IllegalStateException("Authentication failed: " + String.valueOf(exchangedToken.get("error")) + ": " + String.valueOf(exchangedToken.get("error_description")));
            }
            this.env().out().println(new String(Base64.getUrlDecoder().decode((String)exchangedToken.get("access_token")), StandardCharsets.UTF_8));
        }
    }
}

