/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Group;
import com.github.rvesse.airline.annotations.Parser;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.google.common.base.Throwables;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import nl.topicus.keyhub.cli.KeyHubHelp;
import nl.topicus.keyhub.cli.LoginCommand;
import nl.topicus.keyhub.cli.LogoutCommand;
import nl.topicus.keyhub.cli.ServiceAccess;
import nl.topicus.keyhub.cli.Services;
import nl.topicus.keyhub.cli.StatusCommand;
import nl.topicus.keyhub.cli.SwitchCommand;
import nl.topicus.keyhub.cli.VersionCommand;
import nl.topicus.keyhub.cli.provisioning.ActivateProvisioningCommand;
import nl.topicus.keyhub.cli.provisioning.DeactivateProvisioningCommand;
import nl.topicus.keyhub.cli.provisioning.GetProvisioningStatusCommand;
import nl.topicus.keyhub.cli.provisioning.ReadPasswordCommand;
import nl.topicus.keyhub.cli.provisioning.RotatePasswordCommand;
import nl.topicus.keyhub.cli.query.QueryAccountsCommand;
import nl.topicus.keyhub.cli.query.QueryGroupsCommand;
import nl.topicus.keyhub.cli.query.QueryVaultRecordsCommand;
import nl.topicus.keyhub.cli.types.KeyHubCLITypeConverter;
import nl.topicus.keyhub.cli.vault.VaultCopyCommand;
import nl.topicus.keyhub.cli.vault.VaultExportCommand;
import nl.topicus.keyhub.cli.vault.VaultImportCommand;
import nl.topicus.keyhub.cli.vault.VaultListCommand;
import nl.topicus.keyhub.cli.vault.VaultLockCommand;
import nl.topicus.keyhub.cli.vault.VaultMoveCommand;
import nl.topicus.keyhub.cli.vault.VaultReadCommand;
import nl.topicus.keyhub.cli.vault.VaultRmCommand;
import nl.topicus.keyhub.cli.vault.VaultShareCommand;
import nl.topicus.keyhub.cli.vault.VaultUnlockCommand;
import nl.topicus.keyhub.cli.vault.VaultWriteCommand;

@com.github.rvesse.airline.annotations.Cli(name="keyhub", description="Topicus KeyHub CLI", defaultCommand=KeyHubHelp.class, groups={@Group(name="query", description="Query for different types of objects in Topicus KeyHub", commands={QueryAccountsCommand.class, QueryGroupsCommand.class, QueryVaultRecordsCommand.class}), @Group(name="vault", description="Access vaults in Topicus KeyHub", commands={VaultUnlockCommand.class, VaultLockCommand.class, VaultListCommand.class, VaultReadCommand.class, VaultWriteCommand.class, VaultMoveCommand.class, VaultCopyCommand.class, VaultShareCommand.class, VaultRmCommand.class, VaultImportCommand.class, VaultExportCommand.class}), @Group(name="provisioning", description="Control account provisioning in Topicus KeyHub", commands={ReadPasswordCommand.class, RotatePasswordCommand.class, GetProvisioningStatusCommand.class, ActivateProvisioningCommand.class, DeactivateProvisioningCommand.class})}, commands={LoginCommand.class, LogoutCommand.class, StatusCommand.class, SwitchCommand.class, VersionCommand.class, KeyHubHelp.class}, parserConfiguration=@Parser(typeConverter=KeyHubCLITypeConverter.class))
public class KeyHubCLI
implements ServiceAccess {
    private GlobalMetadata<Runnable> globalMetadata;

    public int exec(List<String> params, PrintStream out, PrintStream err, InputStream in, boolean testcase) {
        Services.get().init();
        this.env().customStreams(out, err, in);
        this.env().setTestcase(testcase);
        int exitCode = this.exec(params);
        Services.get().terminate();
        return exitCode;
    }

    private int exec(List<String> parameters) {
        int exitCode;
        block5: {
            Runnable cmd;
            exitCode = 0;
            this.globalMetadata = MetadataLoader.loadGlobal(KeyHubCLI.class);
            Cli<Runnable> cli = new Cli<Runnable>(this.globalMetadata);
            try {
                cmd = cli.parse(parameters.toArray(new String[0]));
                if (cmd instanceof KeyHubHelp && (parameters.isEmpty() || !parameters.get(0).equals("help"))) {
                    exitCode = 2;
                    cmd = cli.parse("help");
                }
            }
            catch (ParseException e) {
                exitCode = 2;
                this.env().err().println(e.getMessage());
                this.env().err().println();
                parameters = new ArrayList<String>(parameters);
                parameters.add(0, "help");
                cmd = cli.parse(parameters.toArray(new String[0]));
            }
            try {
                cmd.run();
            }
            catch (Exception e) {
                Throwables.getCausalChain(e).forEach(t -> this.env().err().println(t.getClass().getSimpleName() + ":" + t.getMessage()));
                exitCode = 1;
                if (!this.env().isTestcase()) break block5;
                e.printStackTrace(this.env().err());
            }
        }
        return exitCode;
    }

    public static void main(String[] args) {
        LogManager.getLogManager().reset();
        Logger.getLogger("").setLevel(Level.OFF);
        System.exit(new KeyHubCLI().exec(Arrays.asList(args), System.out, System.err, System.in, false));
    }
}

