/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import java.io.InputStream;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import nl.topicus.keyhub.cli.AWTDesktopAccess;
import org.apache.commons.io.output.NullPrintStream;

public class CLIEnvironment {
    private static final DateTimeFormatter LOG_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private InputStream in = System.in;
    private boolean verbose;
    private boolean testcase;

    public void customStreams(PrintStream out, PrintStream err, InputStream in) {
        this.out = out;
        this.err = err;
        this.in = in;
    }

    public PrintStream out() {
        return this.out;
    }

    public PrintStream err() {
        return this.err;
    }

    public PrintStream verbose() {
        return this.verbose ? this.err() : NullPrintStream.INSTANCE;
    }

    public void vlog(String output) {
        if (this.verbose) {
            this.verbose().println(ZonedDateTime.now().format(LOG_TIMESTAMP) + " TRACE " + output);
        }
    }

    public InputStream in() {
        return this.in;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isTestcase() {
        return this.testcase;
    }

    public void setTestcase(boolean testcase) {
        this.testcase = testcase;
    }

    public void browse(String url) {
        if (this.testcase) {
            return;
        }
        String myOS = System.getProperty("os.name").toLowerCase();
        try {
            if (AWTDesktopAccess.isDesktopBrowseSupported()) {
                AWTDesktopAccess.browse(url);
            } else {
                Runtime runtime = Runtime.getRuntime();
                if (myOS.contains("mac")) {
                    runtime.exec(new String[]{"open", url});
                } else if (myOS.contains("nix") || myOS.contains("nux")) {
                    runtime.exec(new String[]{"xdg-open", url});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

