/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.AllowedValues;
import com.google.common.base.Strings;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nl.topicus.keyhub.cli.AbstractKeyHubCommand;
import nl.topicus.keyhub.cli.print.CLIObjectPrinter;
import nl.topicus.keyhub.cli.print.OutputLine;
import nl.topicus.keyhub.cli.restrictions.SilentOnce;

public abstract class AbstractKeyHubOutputCommand
extends AbstractKeyHubCommand {
    private static final int COLUMN_SPACING = 3;
    public static final String FMT_UUID = "%-36s";
    public static final String FMT_NAME = "%-32s";
    public static final String OUTPUT_JSON = "json";
    public static final String OUTPUT_PLAIN = "plain";
    public static final String OUTPUT_CSV = "csv";
    public static final String OUTPUT_DETAIL = "detail";
    @Option(name={"--output"}, description="Select the output format.")
    @AllowedValues(allowedValues={"json", "plain", "detail", "csv"})
    @SilentOnce
    private String output = "plain";

    protected <T, E> void print(T value, CLIObjectPrinter<T, E> printer) {
        block24: {
            try {
                if (this.isJsonOutput()) {
                    this.env().out().println(this.restClientBuilder().getMapper().writerWithDefaultPrettyPrinter().writeValueAsString(value));
                    break block24;
                }
                if (this.isPlainOutput()) {
                    List<E> elements;
                    String preface = printer.preface(value);
                    if (preface != null) {
                        this.env().out().println(preface);
                    }
                    if (!(elements = printer.toElements(value)).isEmpty()) {
                        List<String> headers = printer.headers(value);
                        int[] widths = printer.printHeaders(this.output) ? headers.stream().mapToInt(String::length).toArray() : new int[headers.size()];
                        ArrayList<List<String>> lines = new ArrayList<List<String>>(elements.size());
                        for (E curElement : elements) {
                            List<String> curLine = printer.values(curElement);
                            for (int colIndex = 0; colIndex < widths.length - 1; ++colIndex) {
                                String curColValue = Strings.nullToEmpty(curLine.get(colIndex));
                                if (widths[colIndex] >= curColValue.length()) continue;
                                widths[colIndex] = curColValue.length();
                            }
                            lines.add(curLine);
                        }
                        widths[widths.length - 1] = 0;
                        if (printer.printHeaders(this.output)) {
                            this.printLine(widths, headers.stream().map(String::toUpperCase).collect(Collectors.toList()));
                        }
                        lines.forEach(line -> this.printLine(widths, (List<String>)line));
                    }
                    break block24;
                }
                if (this.isDetailOutput()) {
                    List<E> elements;
                    String preface = printer.preface(value);
                    if (preface != null) {
                        this.env().out().println(preface);
                    }
                    if (!(elements = printer.toElements(value)).isEmpty()) {
                        boolean first = true;
                        int[] widths = null;
                        for (E curElement : elements) {
                            List<OutputLine> lines = printer.sectionDetails(curElement);
                            if (!first) {
                                this.env().out().println();
                            } else {
                                widths = new int[]{lines.stream().mapToInt(l -> l.header().length()).max().orElse(0), 0};
                                first = false;
                            }
                            if (printer.printHeaders(this.output)) {
                                this.env().out().println(printer.sectionHeader(curElement).toUpperCase());
                            }
                            for (OutputLine curLine : lines) {
                                if (curLine.value() == null) continue;
                                this.printLine(widths, List.of(curLine.header(), curLine.value().toString()));
                            }
                        }
                    }
                    break block24;
                }
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.env().out(), StandardCharsets.UTF_8);){
                    ICSVWriter csv = new CSVWriterBuilder(writer).build();
                    List<E> elements = printer.toElements(value);
                    if (printer.printHeaders(this.output)) {
                        List<String> headers = printer.headers(value);
                        csv.writeNext((String[])headers.toArray(String[]::new), true);
                    }
                    for (E curElement : elements) {
                        csv.writeNext((String[])printer.values(curElement).toArray(String[]::new), true);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean isJsonOutput() {
        return OUTPUT_JSON.equals(this.output);
    }

    protected boolean isPlainOutput() {
        return OUTPUT_PLAIN.equals(this.output);
    }

    protected boolean isDetailOutput() {
        return OUTPUT_DETAIL.equals(this.output);
    }

    private void printLine(int[] widths, List<String> line) {
        for (int colIndex = 0; colIndex < widths.length; ++colIndex) {
            this.env().out().print(Strings.padEnd(Strings.nullToEmpty(line.get(colIndex)), widths[colIndex] + (colIndex < widths.length - 1 ? 3 : 0), ' '));
        }
        this.env().out().println();
    }
}

