/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.cli;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class AWTDesktopAccess {
    private static final String PROPERTY_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
    private static final String PROPERTY_IMAGE_CODE_VALUE_BUILDTIME = "buildtime";
    private static final String PROPERTY_IMAGE_CODE_VALUE_RUNTIME = "runtime";
    private static final boolean IS_IN_JRE = AWTDesktopAccess.isInJre();

    private static boolean isInJre() {
        String imageCodeProperty = System.getProperty(PROPERTY_IMAGE_CODE_KEY);
        return !PROPERTY_IMAGE_CODE_VALUE_BUILDTIME.equals(imageCodeProperty) && !PROPERTY_IMAGE_CODE_VALUE_RUNTIME.equals(imageCodeProperty);
    }

    public static boolean isDesktopBrowseSupported() {
        return IS_IN_JRE && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    public static void browse(String url) throws IOException, URISyntaxException {
        if (IS_IN_JRE) {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new URI(url));
        }
    }
}

