/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.spi;

import nl.topicus.cobra.spi.ContractService;

public abstract class AbstractContractServiceImpl
implements ContractService {
    private int version;
    private Class<?> versionClass;
    private String basePackageName;
    private String modelPackage;

    public AbstractContractServiceImpl(Class<?> versionClass) {
        this.versionClass = versionClass;
        this.basePackageName = versionClass.getPackage().getName();
        this.modelPackage = this.basePackageName + ".model";
        try {
            this.version = versionClass.getField("NUMBER").getInt(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> getVersionClass() {
        return this.versionClass;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean containsType(Class<?> type) {
        return type.getName().startsWith(this.modelPackage);
    }

    @Override
    public Class<?> resolveModelClass(String name) {
        try {
            return Class.forName(this.getModelPackage() + "." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public String resolveName(Class<?> type) {
        if (!this.containsType(type)) {
            return null;
        }
        return type.getName().substring(this.getModelPackage().length() + 1);
    }

    @Override
    public String getBasePackage() {
        return this.basePackageName;
    }

    @Override
    public String getModelPackage() {
        return this.modelPackage;
    }

    @Override
    public boolean implies(String base, String check) {
        if (base.equals("LANDELIJK")) {
            return !check.equals("LANDELIJK");
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-v" + this.getVersion() + "(" + this.getMediaType() + ")";
    }
}

