/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import nl.topicus.cobra.restcontract.model.Secured;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.cobra.restcontract.security.PermissionCategoryInstance;
import nl.topicus.cobra.spi.ContractFilterService;
import nl.topicus.cobra.spi.ContractService;
import nl.topicus.cobra.spi.ContractSortService;

public class RestPermission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<ContractService> permissionServices;
    private Class<? extends Secured> entity;
    private Set<Operation> operations;
    private List<PermissionCategoryInstance> instances;

    public RestPermission(String permissionStr) {
        String entityName = permissionStr.substring(0, permissionStr.indexOf(58));
        String operationsStr = permissionStr.substring(entityName.length() + 1, permissionStr.indexOf(58, entityName.length() + 1));
        String instanceStr = permissionStr.substring(entityName.length() + operationsStr.length() + 2);
        for (ContractService curService : permissionServices) {
            Class<?> modelClass = curService.resolveModelClass(entityName);
            if (modelClass == null) continue;
            this.entity = modelClass.asSubclass(Secured.class);
            break;
        }
        if (this.entity == null) {
            throw new IllegalArgumentException("No entity class found for '" + entityName + "' (" + permissionStr + ") in " + permissionServices);
        }
        this.operations = EnumSet.noneOf(Operation.class);
        for (String curOperation : operationsStr.split(",")) {
            this.operations.add(Operation.valueOf(curOperation));
        }
        this.instances = new ArrayList<PermissionCategoryInstance>();
        for (String curInstance : instanceStr.split(",")) {
            this.instances.add(new PermissionCategoryInstance(curInstance));
        }
    }

    public RestPermission(Class<? extends Secured> entity, Operation operation, long id) {
        this.entity = entity;
        this.operations = EnumSet.of(operation);
        this.instances = Collections.singletonList(new PermissionCategoryInstance("INSTANCE", id));
    }

    public RestPermission(Class<? extends Secured> entity, Operation operation, PermissionCategoryInstance instance) {
        this.entity = entity;
        this.operations = EnumSet.of(operation);
        this.instances = Collections.singletonList(instance);
    }

    public RestPermission(Class<? extends Secured> entity, Operation operation, String category, long id) {
        this.entity = entity;
        this.operations = EnumSet.of(operation);
        this.instances = Collections.singletonList(new PermissionCategoryInstance(category, id));
    }

    public RestPermission(Class<? extends Secured> entity, Set<Operation> operations, List<PermissionCategoryInstance> instances) {
        this.entity = entity;
        this.operations = operations;
        this.instances = instances;
    }

    public Class<? extends Secured> getEntity() {
        return this.entity;
    }

    public String getEntityName() {
        for (ContractService curService : permissionServices) {
            String ret = curService.resolveName(this.entity);
            if (ret == null) continue;
            return ret;
        }
        return this.entity.getName();
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public List<PermissionCategoryInstance> getInstances() {
        return this.instances;
    }

    public boolean merge(RestPermission permission) {
        if (this.getEntity().equals(permission.getEntity()) && this.getInstances().equals(permission.getInstances())) {
            this.operations.addAll(permission.getOperations());
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128).append(this.getEntityName()).append(':');
        boolean first = true;
        for (Operation curOperation : this.operations) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(curOperation.toString());
        }
        sb.append(':');
        first = true;
        for (PermissionCategoryInstance curInstance : this.instances) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            curInstance.appendTo(sb);
        }
        return sb.toString();
    }

    static {
        ContractFilterService filterService = ContractFilterService.AlwaysTrueContractFilterService.INSTANCE;
        Iterator<ContractFilterService> iterator = ServiceLoader.load(ContractFilterService.class).iterator();
        if (iterator.hasNext()) {
            ContractFilterService curService;
            filterService = curService = iterator.next();
        }
        ContractSortService sortService = ContractSortService.VersionContractSortService.INSTANCE;
        Iterator<Object> iterator2 = ServiceLoader.load(ContractSortService.class).iterator();
        if (iterator2.hasNext()) {
            ContractSortService contractSortService = iterator2.next();
            sortService = contractSortService;
        }
        permissionServices = new ArrayList<ContractService>();
        for (ContractService contractService : ServiceLoader.load(ContractService.class)) {
            if (!filterService.test(contractService)) continue;
            permissionServices.add(contractService);
        }
        Collections.sort(permissionServices, sortService);
    }
}

