/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.security;

import java.io.Serializable;

public class PermissionCategoryInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long UNSAVED_INSTANCE_ID = -1L;
    private static final long SINGLETON_KEY_ID = -2L;
    private static final long LANDELIJK_ID = -3L;
    private static final long NULL_ID = -4L;
    private String category;
    private long id;

    public static PermissionCategoryInstance forNull(String category) {
        return new PermissionCategoryInstance(category, -4L);
    }

    public static PermissionCategoryInstance forLandelijk() {
        return new PermissionCategoryInstance("LANDELIJK", -3L);
    }

    public static PermissionCategoryInstance forSingleton() {
        return new PermissionCategoryInstance("SINGLETON", -2L);
    }

    public static PermissionCategoryInstance forUnsaved() {
        return new PermissionCategoryInstance("INSTANCE", -1L);
    }

    public PermissionCategoryInstance(String instanceStr) {
        this.category = instanceStr.substring(0, instanceStr.indexOf(40));
        this.id = PermissionCategoryInstance.toLong(instanceStr.substring(this.category.length() + 1, instanceStr.length() - 1));
    }

    public PermissionCategoryInstance(String category, long id) {
        this.category = category;
        this.id = id;
    }

    private static long toLong(String string) {
        switch (string) {
            case "NULL": {
                return -4L;
            }
            case "ALL": {
                return -3L;
            }
            case "KEY": {
                return -2L;
            }
            case "NEW": {
                return -1L;
            }
        }
        return Long.parseLong(string);
    }

    private static Object toStringBase(long longValue) {
        if (longValue == -4L) {
            return "NULL";
        }
        if (longValue == -3L) {
            return "ALL";
        }
        if (longValue == -2L) {
            return "KEY";
        }
        if (longValue == -1L) {
            return "NEW";
        }
        return longValue;
    }

    public String getCategory() {
        return this.category;
    }

    public long getId() {
        return this.id;
    }

    public boolean isNullId() {
        return this.id == -4L;
    }

    public String toString() {
        return this.getCategory() + "(" + PermissionCategoryInstance.toStringBase(this.getId()) + ")";
    }

    public int hashCode() {
        return this.getCategory().hashCode() ^ (int)this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PermissionCategoryInstance) {
            PermissionCategoryInstance other = (PermissionCategoryInstance)obj;
            return other.getCategory().equals(this.getCategory()) && other.getId() == this.getId();
        }
        return false;
    }

    public void appendTo(StringBuilder sb) {
        sb.append(this.category).append('(');
        if (this.getId() < 0L) {
            sb.append(PermissionCategoryInstance.toStringBase(this.getId()));
        } else {
            sb.append(this.getId());
        }
        sb.append(')');
    }
}

