/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.resources.auth;

import jakarta.validation.Valid;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.model.CobraSecurityKeys;
import nl.topicus.cobra.restcontract.model.auth.TempAccount;
import nl.topicus.cobra.restcontract.model.auth.UserAccount;
import nl.topicus.cobra.restcontract.model.auth.UserCredentials;
import nl.topicus.cobra.restcontract.model.auth.UserSession;
import nl.topicus.cobra.restcontract.resources.RestResource;
import nl.topicus.cobra.restcontract.resources.auth.OAuth2Resource;
import nl.topicus.cobra.restcontract.resources.auth.RemoteAuthenticationResource;

public interface UserAccountResource
extends RestResource {
    public static final String RESOURCE_PATH = "/auth";

    @POST
    @Path(value="me")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    public Response me(@Valid UserCredentials var1);

    @DELETE
    @Path(value="me")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    public Response logout(@Valid UserSession var1, @QueryParam(value="provider") String var2, @QueryParam(value="postlogout") String var3);

    @GET
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    public UserAccount get(@QueryParam(value="subject") String var1);

    @Path(value="remote")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    public RemoteAuthenticationResource getRemoteAuthentication();

    @Path(value="oauth2")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    public OAuth2Resource getOAuth2();

    @POST
    @Path(value="tmp")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    public TempAccount createTempAccount(@Valid UserCredentials var1);
}

