/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.model.auth;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.cobra.restcontract.model.auth.UserSessionConstraints;
import nl.topicus.cobra.restcontract.model.auth.VerifiedRemoteIdentity;
import nl.topicus.cobra.restcontract.xmladapter.StringMapAdapter;
import org.joda.time.DateTime;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String subject;
    @XmlElement
    private String username;
    @XmlElement
    private String password;
    @XmlElement
    private String otpToken;
    @XmlElement
    private String storedSessionId;
    @XmlElement
    private String idp;
    @XmlElement
    private DateTime authTime;
    @XmlElement
    private String oauth2Token;
    @XmlElement
    private VerifiedRemoteIdentity remoteIdentity;
    @XmlElement
    private String ipAddress;
    @XmlElement
    private String userAgent;
    @XmlElement
    private String subjectToImpersonate;
    @XmlElement
    private String protocolFlow;
    @XmlElement
    private String targetClientId;
    @XmlElement
    private List<String> allClientIds;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringMapAdapter.class)
    private Map<String, String> otherAttributes;
    @XmlElement
    private UserSessionConstraints constraints;
    @XmlElement
    private String webAuthnRequest;
    @XmlElement
    private String webAuthnResponse;

    public static UserCredentials forUsernamePassword(String username, String password) {
        UserCredentials ret = new UserCredentials();
        ret.setUsername(username);
        ret.setPassword(password);
        return ret;
    }

    public static UserCredentials forStoredSession(String subject, String sessionId, DateTime authTime) {
        UserCredentials ret = new UserCredentials();
        ret.setSubject(subject);
        ret.setStoredSessionId(sessionId);
        ret.setAuthTime(authTime);
        return ret;
    }

    public static UserCredentials forOauth2Token(String oauth2Token, String clientId) {
        UserCredentials ret = new UserCredentials();
        ret.setOauth2Token(oauth2Token);
        ret.setProtocolFlow("OAUTH2");
        ret.setTargetClientId(clientId);
        return ret;
    }

    public static UserCredentials forRemoteIdentity(VerifiedRemoteIdentity remoteIdentity) {
        UserCredentials ret = new UserCredentials();
        ret.setRemoteIdentity(remoteIdentity);
        return ret;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOtpToken() {
        return this.otpToken;
    }

    public void setOtpToken(String otpToken) {
        this.otpToken = otpToken;
    }

    public String getStoredSessionId() {
        return this.storedSessionId;
    }

    public void setStoredSessionId(String storedSessionId) {
        this.storedSessionId = storedSessionId;
    }

    public String getIdp() {
        return this.idp;
    }

    public void setIdp(String idp) {
        this.idp = idp;
    }

    public DateTime getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(DateTime authTime) {
        this.authTime = authTime;
    }

    public String getOauth2Token() {
        return this.oauth2Token;
    }

    public void setOauth2Token(String oauth2Token) {
        this.oauth2Token = oauth2Token;
    }

    public VerifiedRemoteIdentity getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public void setRemoteIdentity(VerifiedRemoteIdentity remoteIdentity) {
        this.remoteIdentity = remoteIdentity;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getSubjectToImpersonate() {
        return this.subjectToImpersonate;
    }

    public void setSubjectToImpersonate(String subjectToImpersonate) {
        this.subjectToImpersonate = subjectToImpersonate;
    }

    public String getProtocolFlow() {
        return this.protocolFlow;
    }

    public void setProtocolFlow(String protocolFlow) {
        this.protocolFlow = protocolFlow;
    }

    public String getTargetClientId() {
        return this.targetClientId;
    }

    public void setTargetClientId(String targetClientId) {
        this.targetClientId = targetClientId;
    }

    public List<String> getAllClientIds() {
        return this.allClientIds;
    }

    public void setAllClientIds(List<String> allClientIds) {
        this.allClientIds = allClientIds;
    }

    public UserSessionConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(UserSessionConstraints constraints) {
        this.constraints = constraints;
    }

    public Map<String, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setOtherAttributes(Map<String, String> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public UserCredentials addOtherAttribute(String name, String value) {
        if (this.otherAttributes == null) {
            this.otherAttributes = new HashMap<String, String>();
        }
        this.otherAttributes.put(name, value);
        return this;
    }

    public String getWebAuthnRequest() {
        return this.webAuthnRequest;
    }

    public void setWebAuthnRequest(String webAuthnRequest) {
        this.webAuthnRequest = webAuthnRequest;
    }

    public String getWebAuthnResponse() {
        return this.webAuthnResponse;
    }

    public void setWebAuthnResponse(String webAuthnResponse) {
        this.webAuthnResponse = webAuthnResponse;
    }
}

