/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.cobra.restcontract.model.auth;

import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.cobra.restcontract.model.auth.AuthenticationParameter;
import nl.topicus.cobra.restcontract.model.auth.RemoteAuthentication;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RemoteAuthenticationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private RemoteAuthentication authentication;
    @XmlElement(name="parameter")
    @XmlElementWrapper
    @Valid
    private List<AuthenticationParameter> parameters = new ArrayList<AuthenticationParameter>();

    public RemoteAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(RemoteAuthentication authentication) {
        this.authentication = authentication;
    }

    public List<AuthenticationParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<AuthenticationParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.getParameters().add(new AuthenticationParameter(key, value));
    }

    public String getParameter(String name) {
        for (AuthenticationParameter curParam : this.getParameters()) {
            if (!curParam.getKey().equals(name)) continue;
            return curParam.getValue();
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        for (AuthenticationParameter curParam : this.getParameters()) {
            ret.put(curParam.getKey(), new String[]{curParam.getValue()});
        }
        return ret;
    }
}

